
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;

@XmlType(name = "OPTYPE", namespace = "http://www.dmg.org/PMML-4_4")
@XmlEnum
public enum OpType
    implements StringValue<OpType>
{

    @XmlEnumValue("categorical")
    @JsonProperty("categorical")
    CATEGORICAL("categorical"),
    @XmlEnumValue("ordinal")
    @JsonProperty("ordinal")
    ORDINAL("ordinal"),
    @XmlEnumValue("continuous")
    @JsonProperty("continuous")
    CONTINUOUS("continuous");
    private final String value;

    OpType(String v) {
        value = v;
    }

    @Override
    public String value() {
        return value;
    }

    public static OpType fromValue(String v) {
        for (OpType c: OpType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String toString() {
        return value();
    }

}
