
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Taxonomy", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "childParents"
})
@JsonRootName("Taxonomy")
@JsonPropertyOrder({
    "name",
    "extensions",
    "childParents"
})
public class Taxonomy
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Taxonomy> , HasRequiredName<Taxonomy>
{

    @XmlAttribute(name = "name", required = true)
    @JsonProperty("name")
    private String name;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ChildParent", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ChildParent")
    private List<ChildParent> childParents;
    private final static long serialVersionUID = 67371271L;

    public Taxonomy() {
    }

    @ValueConstructor
    public Taxonomy(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("childParents")
        List<ChildParent> childParents) {
        this.name = name;
        this.childParents = childParents;
    }

    @Override
    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.TAXONOMY_NAME);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public Taxonomy setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Taxonomy addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasChildParents() {
        return ((this.childParents!= null)&&(!this.childParents.isEmpty()));
    }

    public List<ChildParent> requireChildParents() {
        if ((this.childParents == null)||this.childParents.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.TAXONOMY_CHILDPARENTS);
        }
        return this.childParents;
    }

    public List<ChildParent> getChildParents() {
        if (childParents == null) {
            childParents = new ArrayList<ChildParent>();
        }
        return this.childParents;
    }

    public Taxonomy addChildParents(ChildParent... childParents) {
        getChildParents().addAll(Arrays.asList(childParents));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasChildParents()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getChildParents());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
