
package org.dmg.pmml.naive_bayes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelExplanation;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Targets;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NaiveBayesModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "bayesInputs",
    "bayesOutput",
    "modelVerification"
})
@JsonRootName("NaiveBayesModel")
@JsonPropertyOrder({
    "modelName",
    "threshold",
    "miningFunction",
    "algorithmName",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "output",
    "modelStats",
    "modelExplanation",
    "targets",
    "localTransformations",
    "bayesInputs",
    "bayesOutput",
    "modelVerification"
})
public class NaiveBayesModel
    extends Model
    implements HasExtensions<NaiveBayesModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "threshold", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("threshold")
    private Number threshold;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @JsonProperty("x-mathContext")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.XPMML), removable = (true))
    @Since(("1.3.7"))
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "Output", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Output")
    private Output output;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "ModelExplanation", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelExplanation")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_0), removable = (true))
    private ModelExplanation modelExplanation;
    @XmlElement(name = "Targets", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Targets")
    private Targets targets;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "BayesInputs", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("BayesInputs")
    private BayesInputs bayesInputs;
    @XmlElement(name = "BayesOutput", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("BayesOutput")
    private BayesOutput bayesOutput;
    @XmlElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelVerification")
    private ModelVerification modelVerification;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371271L;

    public NaiveBayesModel() {
    }

    @ValueConstructor
    public NaiveBayesModel(
        @org.jpmml.model.annotations.Property("threshold")
        Number threshold,
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("bayesInputs")
        BayesInputs bayesInputs,
        @org.jpmml.model.annotations.Property("bayesOutput")
        BayesOutput bayesOutput) {
        this.threshold = threshold;
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
        this.bayesInputs = bayesInputs;
        this.bayesOutput = bayesOutput;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public NaiveBayesModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    public Number requireThreshold() {
        if (this.threshold == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NAIVEBAYESMODEL_THRESHOLD);
        }
        return this.threshold;
    }

    public Number getThreshold() {
        return threshold;
    }

    public NaiveBayesModel setThreshold(
        @org.jpmml.model.annotations.Property("threshold")
        Number threshold) {
        this.threshold = threshold;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NAIVEBAYESMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public NaiveBayesModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public NaiveBayesModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public NaiveBayesModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public NaiveBayesModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NaiveBayesModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.NAIVEBAYESMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public NaiveBayesModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return output;
    }

    @Override
    public NaiveBayesModel setOutput(
        @org.jpmml.model.annotations.Property("output")
        Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public NaiveBayesModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return modelExplanation;
    }

    @Override
    public NaiveBayesModel setModelExplanation(
        @org.jpmml.model.annotations.Property("modelExplanation")
        ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return targets;
    }

    @Override
    public NaiveBayesModel setTargets(
        @org.jpmml.model.annotations.Property("targets")
        Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public NaiveBayesModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public BayesInputs requireBayesInputs() {
        if (this.bayesInputs == null) {
            throw new MissingElementException(this, PMMLElements.NAIVEBAYESMODEL_BAYESINPUTS);
        }
        return this.bayesInputs;
    }

    public BayesInputs getBayesInputs() {
        return bayesInputs;
    }

    public NaiveBayesModel setBayesInputs(
        @org.jpmml.model.annotations.Property("bayesInputs")
        BayesInputs bayesInputs) {
        this.bayesInputs = bayesInputs;
        return this;
    }

    public BayesOutput requireBayesOutput() {
        if (this.bayesOutput == null) {
            throw new MissingElementException(this, PMMLElements.NAIVEBAYESMODEL_BAYESOUTPUT);
        }
        return this.bayesOutput;
    }

    public BayesOutput getBayesOutput() {
        return bayesOutput;
    }

    public NaiveBayesModel setBayesOutput(
        @org.jpmml.model.annotations.Property("bayesOutput")
        BayesOutput bayesOutput) {
        this.bayesOutput = bayesOutput;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return modelVerification;
    }

    @Override
    public NaiveBayesModel setModelVerification(
        @org.jpmml.model.annotations.Property("modelVerification")
        ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getOutput(), getModelStats(), getModelExplanation(), getTargets(), getLocalTransformations(), getBayesInputs(), getBayesOutput(), getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
