
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NeuralOutput", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedField"
})
@JsonRootName("NeuralOutput")
@JsonPropertyOrder({
    "outputNeuron",
    "extensions",
    "derivedField"
})
public class NeuralOutput
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NeuralOutput>
{

    @XmlAttribute(name = "outputNeuron", required = true)
    @JsonProperty("outputNeuron")
    private String outputNeuron;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("DerivedField")
    private DerivedField derivedField;
    private final static long serialVersionUID = 67371271L;

    public NeuralOutput() {
    }

    @ValueConstructor
    public NeuralOutput(
        @org.jpmml.model.annotations.Property("outputNeuron")
        String outputNeuron,
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.outputNeuron = outputNeuron;
        this.derivedField = derivedField;
    }

    public String requireOutputNeuron() {
        if (this.outputNeuron == null) {
            throw new MissingAttributeException(this, PMMLAttributes.NEURALOUTPUT_OUTPUTNEURON);
        }
        return this.outputNeuron;
    }

    public String getOutputNeuron() {
        return outputNeuron;
    }

    public NeuralOutput setOutputNeuron(
        @org.jpmml.model.annotations.Property("outputNeuron")
        String outputNeuron) {
        this.outputNeuron = outputNeuron;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public NeuralOutput addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public DerivedField requireDerivedField() {
        if (this.derivedField == null) {
            throw new MissingElementException(this, PMMLElements.NEURALOUTPUT_DERIVEDFIELD);
        }
        return this.derivedField;
    }

    public DerivedField getDerivedField() {
        return derivedField;
    }

    public NeuralOutput setDerivedField(
        @org.jpmml.model.annotations.Property("derivedField")
        DerivedField derivedField) {
        this.derivedField = derivedField;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedField());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
