
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "GARCHPart", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "residualSquareCoefficients",
    "varianceCoefficients"
})
@JsonRootName("GARCHPart")
@JsonPropertyOrder({
    "constant",
    "gp",
    "gq",
    "extensions",
    "residualSquareCoefficients",
    "varianceCoefficients"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class GARCHPart
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<GARCHPart>
{

    @XmlAttribute(name = "constant")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("constant")
    private Number constant;
    @XmlAttribute(name = "gp", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("gp")
    private Integer gp;
    @XmlAttribute(name = "gq", required = true)
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("gq")
    private Integer gq;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ResidualSquareCoefficients", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ResidualSquareCoefficients")
    private ResidualSquareCoefficients residualSquareCoefficients;
    @XmlElement(name = "VarianceCoefficients", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("VarianceCoefficients")
    private VarianceCoefficients varianceCoefficients;
    private final static Number DEFAULT_CONSTANT = new RealNumberAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371271L;

    public GARCHPart() {
    }

    @ValueConstructor
    public GARCHPart(
        @org.jpmml.model.annotations.Property("gp")
        Integer gp,
        @org.jpmml.model.annotations.Property("gq")
        Integer gq,
        @org.jpmml.model.annotations.Property("residualSquareCoefficients")
        ResidualSquareCoefficients residualSquareCoefficients,
        @org.jpmml.model.annotations.Property("varianceCoefficients")
        VarianceCoefficients varianceCoefficients) {
        this.gp = gp;
        this.gq = gq;
        this.residualSquareCoefficients = residualSquareCoefficients;
        this.varianceCoefficients = varianceCoefficients;
    }

    public Number getConstant() {
        if (constant == null) {
            return DEFAULT_CONSTANT;
        } else {
            return constant;
        }
    }

    public GARCHPart setConstant(
        @org.jpmml.model.annotations.Property("constant")
        Number constant) {
        this.constant = constant;
        return this;
    }

    public Integer requireGp() {
        if (this.gp == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GARCHPART_GP);
        }
        return this.gp;
    }

    public Integer getGp() {
        return gp;
    }

    public GARCHPart setGp(
        @org.jpmml.model.annotations.Property("gp")
        Integer gp) {
        this.gp = gp;
        return this;
    }

    public Integer requireGq() {
        if (this.gq == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GARCHPART_GQ);
        }
        return this.gq;
    }

    public Integer getGq() {
        return gq;
    }

    public GARCHPart setGq(
        @org.jpmml.model.annotations.Property("gq")
        Integer gq) {
        this.gq = gq;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GARCHPart addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ResidualSquareCoefficients requireResidualSquareCoefficients() {
        if (this.residualSquareCoefficients == null) {
            throw new MissingElementException(this, PMMLElements.GARCHPART_RESIDUALSQUARECOEFFICIENTS);
        }
        return this.residualSquareCoefficients;
    }

    public ResidualSquareCoefficients getResidualSquareCoefficients() {
        return residualSquareCoefficients;
    }

    public GARCHPart setResidualSquareCoefficients(
        @org.jpmml.model.annotations.Property("residualSquareCoefficients")
        ResidualSquareCoefficients residualSquareCoefficients) {
        this.residualSquareCoefficients = residualSquareCoefficients;
        return this;
    }

    public VarianceCoefficients requireVarianceCoefficients() {
        if (this.varianceCoefficients == null) {
            throw new MissingElementException(this, PMMLElements.GARCHPART_VARIANCECOEFFICIENTS);
        }
        return this.varianceCoefficients;
    }

    public VarianceCoefficients getVarianceCoefficients() {
        return varianceCoefficients;
    }

    public GARCHPart setVarianceCoefficients(
        @org.jpmml.model.annotations.Property("varianceCoefficients")
        VarianceCoefficients varianceCoefficients) {
        this.varianceCoefficients = varianceCoefficients;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getResidualSquareCoefficients(), getVarianceCoefficients());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
