/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.anomaly_detection;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelVerification;
import org.dmg.pmml.Output;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.anomaly_detection.MeanClusterDistances;
import org.dmg.pmml.anomaly_detection.PMMLAttributes;
import org.dmg.pmml.anomaly_detection.PMMLElements;
import org.dmg.pmml.association.AssociationModel;
import org.dmg.pmml.baseline.BaselineModel;
import org.dmg.pmml.bayesian_network.BayesianNetworkModel;
import org.dmg.pmml.clustering.ClusteringModel;
import org.dmg.pmml.gaussian_process.GaussianProcessModel;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.mining.MiningModel;
import org.dmg.pmml.naive_bayes.NaiveBayesModel;
import org.dmg.pmml.nearest_neighbor.NearestNeighborModel;
import org.dmg.pmml.neural_network.NeuralNetwork;
import org.dmg.pmml.regression.RegressionModel;
import org.dmg.pmml.rule_set.RuleSetModel;
import org.dmg.pmml.scorecard.Scorecard;
import org.dmg.pmml.sequence.SequenceModel;
import org.dmg.pmml.support_vector_machine.SupportVectorMachineModel;
import org.dmg.pmml.text.TextModel;
import org.dmg.pmml.time_series.TimeSeriesModel;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="AnomalyDetectionModel", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "localTransformations", "modelVerification", "model", "meanClusterDistances"})
@JsonRootName(value="AnomalyDetectionModel")
@JsonPropertyOrder(value={"modelName", "algorithmName", "miningFunction", "algorithmType", "sampleDataSize", "scorable", "mathContext", "extensions", "miningSchema", "output", "localTransformations", "modelVerification", "model", "meanClusterDistances"})
@Added(value=Version.PMML_4_4)
public class AnomalyDetectionModel
extends Model
implements HasExtensions<AnomalyDetectionModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmType", required=true)
    @JsonProperty(value="algorithmType")
    private String algorithmType;
    @XmlAttribute(name="sampleDataSize")
    @JsonProperty(value="sampleDataSize")
    private String sampleDataSize;
    @XmlAttribute(name="isScorable")
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @JsonProperty(value="x-mathContext")
    @Added(value=Version.XPMML, removable=true)
    @Since(value="1.5.0")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_4", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    @XmlElements(value={@XmlElement(name="AnomalyDetectionModel", namespace="http://www.dmg.org/PMML-4_4", type=AnomalyDetectionModel.class), @XmlElement(name="AssociationModel", namespace="http://www.dmg.org/PMML-4_4", type=AssociationModel.class), @XmlElement(name="BayesianNetworkModel", namespace="http://www.dmg.org/PMML-4_4", type=BayesianNetworkModel.class), @XmlElement(name="BaselineModel", namespace="http://www.dmg.org/PMML-4_4", type=BaselineModel.class), @XmlElement(name="ClusteringModel", namespace="http://www.dmg.org/PMML-4_4", type=ClusteringModel.class), @XmlElement(name="GaussianProcessModel", namespace="http://www.dmg.org/PMML-4_4", type=GaussianProcessModel.class), @XmlElement(name="GeneralRegressionModel", namespace="http://www.dmg.org/PMML-4_4", type=GeneralRegressionModel.class), @XmlElement(name="MiningModel", namespace="http://www.dmg.org/PMML-4_4", type=MiningModel.class), @XmlElement(name="NaiveBayesModel", namespace="http://www.dmg.org/PMML-4_4", type=NaiveBayesModel.class), @XmlElement(name="NearestNeighborModel", namespace="http://www.dmg.org/PMML-4_4", type=NearestNeighborModel.class), @XmlElement(name="NeuralNetwork", namespace="http://www.dmg.org/PMML-4_4", type=NeuralNetwork.class), @XmlElement(name="RegressionModel", namespace="http://www.dmg.org/PMML-4_4", type=RegressionModel.class), @XmlElement(name="RuleSetModel", namespace="http://www.dmg.org/PMML-4_4", type=RuleSetModel.class), @XmlElement(name="SequenceModel", namespace="http://www.dmg.org/PMML-4_4", type=SequenceModel.class), @XmlElement(name="Scorecard", namespace="http://www.dmg.org/PMML-4_4", type=Scorecard.class), @XmlElement(name="SupportVectorMachineModel", namespace="http://www.dmg.org/PMML-4_4", type=SupportVectorMachineModel.class), @XmlElement(name="TextModel", namespace="http://www.dmg.org/PMML-4_4", type=TextModel.class), @XmlElement(name="TimeSeriesModel", namespace="http://www.dmg.org/PMML-4_4", type=TimeSeriesModel.class), @XmlElement(name="TreeModel", namespace="http://www.dmg.org/PMML-4_4", type=TreeModel.class)})
    @JsonProperty(value="Model")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="AnomalyDetectionModel", value=AnomalyDetectionModel.class), @JsonSubTypes.Type(name="AssociationModel", value=AssociationModel.class), @JsonSubTypes.Type(name="BayesianNetworkModel", value=BayesianNetworkModel.class), @JsonSubTypes.Type(name="BaselineModel", value=BaselineModel.class), @JsonSubTypes.Type(name="ClusteringModel", value=ClusteringModel.class), @JsonSubTypes.Type(name="GaussianProcessModel", value=GaussianProcessModel.class), @JsonSubTypes.Type(name="GeneralRegressionModel", value=GeneralRegressionModel.class), @JsonSubTypes.Type(name="MiningModel", value=MiningModel.class), @JsonSubTypes.Type(name="NaiveBayesModel", value=NaiveBayesModel.class), @JsonSubTypes.Type(name="NearestNeighborModel", value=NearestNeighborModel.class), @JsonSubTypes.Type(name="NeuralNetwork", value=NeuralNetwork.class), @JsonSubTypes.Type(name="RegressionModel", value=RegressionModel.class), @JsonSubTypes.Type(name="RuleSetModel", value=RuleSetModel.class), @JsonSubTypes.Type(name="SequenceModel", value=SequenceModel.class), @JsonSubTypes.Type(name="Scorecard", value=Scorecard.class), @JsonSubTypes.Type(name="SupportVectorMachineModel", value=SupportVectorMachineModel.class), @JsonSubTypes.Type(name="TextModel", value=TextModel.class), @JsonSubTypes.Type(name="TimeSeriesModel", value=TimeSeriesModel.class), @JsonSubTypes.Type(name="TreeModel", value=TreeModel.class)})
    private Model model;
    @XmlElement(name="MeanClusterDistances", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="MeanClusterDistances")
    private MeanClusterDistances meanClusterDistances;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67371271L;

    public AnomalyDetectionModel() {
    }

    @ValueConstructor
    public AnomalyDetectionModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="algorithmType") String algorithmType, @Property(value="miningSchema") MiningSchema miningSchema, @Property(value="model") Model model) {
        this.miningFunction = miningFunction;
        this.algorithmType = algorithmType;
        this.miningSchema = miningSchema;
        this.model = model;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public AnomalyDetectionModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public AnomalyDetectionModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANOMALYDETECTIONMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public AnomalyDetectionModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    public String requireAlgorithmType() {
        if (this.algorithmType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANOMALYDETECTIONMODEL_ALGORITHMTYPE);
        }
        return this.algorithmType;
    }

    public String getAlgorithmType() {
        return this.algorithmType;
    }

    public AnomalyDetectionModel setAlgorithmType(@Property(value="algorithmType") String algorithmType) {
        this.algorithmType = algorithmType;
        return this;
    }

    public String getSampleDataSize() {
        return this.sampleDataSize;
    }

    public AnomalyDetectionModel setSampleDataSize(@Property(value="sampleDataSize") String sampleDataSize) {
        this.sampleDataSize = sampleDataSize;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public AnomalyDetectionModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public AnomalyDetectionModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AnomalyDetectionModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.ANOMALYDETECTIONMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public AnomalyDetectionModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public AnomalyDetectionModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public AnomalyDetectionModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public AnomalyDetectionModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    public Model requireModel() {
        if (this.model == null) {
            throw new MissingElementException(this, PMMLElements.ANOMALYDETECTIONMODEL_MODEL);
        }
        return this.model;
    }

    public Model getModel() {
        return this.model;
    }

    public AnomalyDetectionModel setModel(@Property(value="model") Model model) {
        this.model = model;
        return this;
    }

    public MeanClusterDistances getMeanClusterDistances() {
        return this.meanClusterDistances;
    }

    public AnomalyDetectionModel setMeanClusterDistances(@Property(value="meanClusterDistances") MeanClusterDistances meanClusterDistances) {
        this.meanClusterDistances = meanClusterDistances;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getLocalTransformations(), this.getModelVerification(), this.getModel(), this.getMeanClusterDistances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

