
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ComparisonMeasure", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "measure"
})
@JsonRootName("ComparisonMeasure")
@JsonPropertyOrder({
    "kind",
    "compareFunction",
    "minimum",
    "maximum",
    "extensions",
    "measure"
})
public class ComparisonMeasure
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ComparisonMeasure>
{

    @XmlAttribute(name = "kind", required = true)
    @JsonProperty("kind")
    private ComparisonMeasure.Kind kind;
    @XmlAttribute(name = "compareFunction")
    @JsonProperty("compareFunction")
    private CompareFunction compareFunction;
    @XmlAttribute(name = "minimum")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("minimum")
    private Number minimum;
    @XmlAttribute(name = "maximum")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("maximum")
    private Number maximum;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "euclidean", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Euclidean.class),
        @XmlElement(name = "squaredEuclidean", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SquaredEuclidean.class),
        @XmlElement(name = "chebychev", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Chebychev.class),
        @XmlElement(name = "cityBlock", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.CityBlock.class),
        @XmlElement(name = "minkowski", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Minkowski.class),
        @XmlElement(name = "simpleMatching", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimpleMatching.class),
        @XmlElement(name = "jaccard", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Jaccard.class),
        @XmlElement(name = "tanimoto", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Tanimoto.class),
        @XmlElement(name = "binarySimilarity", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.BinarySimilarity.class)
    })
    @JsonProperty("Measure")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Euclidean", value = org.dmg.pmml.Euclidean.class),
        @JsonSubTypes.Type(name = "SquaredEuclidean", value = org.dmg.pmml.SquaredEuclidean.class),
        @JsonSubTypes.Type(name = "Chebychev", value = org.dmg.pmml.Chebychev.class),
        @JsonSubTypes.Type(name = "CityBlock", value = org.dmg.pmml.CityBlock.class),
        @JsonSubTypes.Type(name = "Minkowski", value = org.dmg.pmml.Minkowski.class),
        @JsonSubTypes.Type(name = "SimpleMatching", value = org.dmg.pmml.SimpleMatching.class),
        @JsonSubTypes.Type(name = "Jaccard", value = org.dmg.pmml.Jaccard.class),
        @JsonSubTypes.Type(name = "Tanimoto", value = org.dmg.pmml.Tanimoto.class),
        @JsonSubTypes.Type(name = "BinarySimilarity", value = org.dmg.pmml.BinarySimilarity.class)
    })
    private Measure measure;
    private final static long serialVersionUID = 67371272L;

    public ComparisonMeasure() {
    }

    @ValueConstructor
    public ComparisonMeasure(
        @org.jpmml.model.annotations.Property("kind")
        ComparisonMeasure.Kind kind,
        @org.jpmml.model.annotations.Property("measure")
        Measure measure) {
        this.kind = kind;
        this.measure = measure;
    }

    public ComparisonMeasure.Kind requireKind() {
        if (this.kind == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPARISONMEASURE_KIND);
        }
        return this.kind;
    }

    public ComparisonMeasure.Kind getKind() {
        return kind;
    }

    public ComparisonMeasure setKind(
        @org.jpmml.model.annotations.Property("kind")
        ComparisonMeasure.Kind kind) {
        this.kind = kind;
        return this;
    }

    public CompareFunction getCompareFunction() {
        if (compareFunction == null) {
            return CompareFunction.ABS_DIFF;
        } else {
            return compareFunction;
        }
    }

    public ComparisonMeasure setCompareFunction(
        @org.jpmml.model.annotations.Property("compareFunction")
        CompareFunction compareFunction) {
        this.compareFunction = compareFunction;
        return this;
    }

    public Number getMinimum() {
        return minimum;
    }

    public ComparisonMeasure setMinimum(
        @org.jpmml.model.annotations.Property("minimum")
        Number minimum) {
        this.minimum = minimum;
        return this;
    }

    public Number getMaximum() {
        return maximum;
    }

    public ComparisonMeasure setMaximum(
        @org.jpmml.model.annotations.Property("maximum")
        Number maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ComparisonMeasure addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Measure requireMeasure() {
        if (this.measure == null) {
            throw new MissingElementException(this, PMMLElements.COMPARISONMEASURE_MEASURE);
        }
        return this.measure;
    }

    public Measure getMeasure() {
        return measure;
    }

    public ComparisonMeasure setMeasure(
        @org.jpmml.model.annotations.Property("measure")
        Measure measure) {
        this.measure = measure;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMeasure());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Kind
        implements StringValue<ComparisonMeasure.Kind>
    {

        @XmlEnumValue("distance")
        @JsonProperty("distance")
        DISTANCE("distance"),
        @XmlEnumValue("similarity")
        @JsonProperty("similarity")
        SIMILARITY("similarity");
        private final String value;

        Kind(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static ComparisonMeasure.Kind fromValue(String v) {
            for (ComparisonMeasure.Kind c: ComparisonMeasure.Kind.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
