
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.PercentageNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Quantile", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Quantile")
@JsonPropertyOrder({
    "quantileLimit",
    "quantileValue",
    "extensions"
})
public class Quantile
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Quantile>
{

    @XmlAttribute(name = "quantileLimit", required = true)
    @XmlJavaTypeAdapter(PercentageNumberAdapter.class)
    @JsonProperty("quantileLimit")
    private Number quantileLimit;
    @XmlAttribute(name = "quantileValue", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("quantileValue")
    private Number quantileValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371272L;

    public Quantile() {
    }

    @ValueConstructor
    public Quantile(
        @org.jpmml.model.annotations.Property("quantileLimit")
        Number quantileLimit,
        @org.jpmml.model.annotations.Property("quantileValue")
        Number quantileValue) {
        this.quantileLimit = quantileLimit;
        this.quantileValue = quantileValue;
    }

    public Number requireQuantileLimit() {
        if (this.quantileLimit == null) {
            throw new MissingAttributeException(this, PMMLAttributes.QUANTILE_QUANTILELIMIT);
        }
        return this.quantileLimit;
    }

    public Number getQuantileLimit() {
        return quantileLimit;
    }

    public Quantile setQuantileLimit(
        @org.jpmml.model.annotations.Property("quantileLimit")
        Number quantileLimit) {
        this.quantileLimit = quantileLimit;
        return this;
    }

    public Number requireQuantileValue() {
        if (this.quantileValue == null) {
            throw new MissingAttributeException(this, PMMLAttributes.QUANTILE_QUANTILEVALUE);
        }
        return this.quantileValue;
    }

    public Number getQuantileValue() {
        return quantileValue;
    }

    public Quantile setQuantileValue(
        @org.jpmml.model.annotations.Property("quantileValue")
        Number quantileValue) {
        this.quantileValue = quantileValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Quantile addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
