
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "YCoordinates", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "array"
})
@JsonRootName("YCoordinates")
@JsonPropertyOrder({
    "extensions",
    "array"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class YCoordinates
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<YCoordinates> , HasRequiredArray<YCoordinates>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private Array array;
    private final static long serialVersionUID = 67371272L;

    public YCoordinates() {
    }

    @ValueConstructor
    public YCoordinates(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public YCoordinates addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.YCOORDINATES_ARRAY);
        }
        return this.array;
    }

    @Override
    public Array getArray() {
        return array;
    }

    @Override
    public YCoordinates setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
