
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "DiscreteConditionalProbability", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "parentValues",
    "valueProbabilities"
})
@JsonRootName("DiscreteConditionalProbability")
@JsonPropertyOrder({
    "count",
    "extensions",
    "parentValues",
    "valueProbabilities"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
public class DiscreteConditionalProbability
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<DiscreteConditionalProbability>
{

    @XmlAttribute(name = "count")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("count")
    private Number count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "ParentValue", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ParentValue")
    private List<ParentValue> parentValues;
    @XmlElement(name = "ValueProbability", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ValueProbability")
    private List<ValueProbability> valueProbabilities;
    private final static long serialVersionUID = 67371272L;

    public DiscreteConditionalProbability() {
    }

    @ValueConstructor
    public DiscreteConditionalProbability(
        @org.jpmml.model.annotations.Property("parentValues")
        List<ParentValue> parentValues,
        @org.jpmml.model.annotations.Property("valueProbabilities")
        List<ValueProbability> valueProbabilities) {
        this.parentValues = parentValues;
        this.valueProbabilities = valueProbabilities;
    }

    public Number getCount() {
        return count;
    }

    public DiscreteConditionalProbability setCount(
        @org.jpmml.model.annotations.Property("count")
        Number count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public DiscreteConditionalProbability addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParentValues() {
        return ((this.parentValues!= null)&&(!this.parentValues.isEmpty()));
    }

    public List<ParentValue> requireParentValues() {
        if ((this.parentValues == null)||this.parentValues.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.DISCRETECONDITIONALPROBABILITY_PARENTVALUES);
        }
        return this.parentValues;
    }

    public List<ParentValue> getParentValues() {
        if (parentValues == null) {
            parentValues = new ArrayList<ParentValue>();
        }
        return this.parentValues;
    }

    public DiscreteConditionalProbability addParentValues(ParentValue... parentValues) {
        getParentValues().addAll(Arrays.asList(parentValues));
        return this;
    }

    public boolean hasValueProbabilities() {
        return ((this.valueProbabilities!= null)&&(!this.valueProbabilities.isEmpty()));
    }

    public List<ValueProbability> requireValueProbabilities() {
        if ((this.valueProbabilities == null)||this.valueProbabilities.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.DISCRETECONDITIONALPROBABILITY_VALUEPROBABILITIES);
        }
        return this.valueProbabilities;
    }

    public List<ValueProbability> getValueProbabilities() {
        if (valueProbabilities == null) {
            valueProbabilities = new ArrayList<ValueProbability>();
        }
        return this.valueProbabilities;
    }

    public DiscreteConditionalProbability addValueProbabilities(ValueProbability... valueProbabilities) {
        getValueProbabilities().addAll(Arrays.asList(valueProbabilities));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParentValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParentValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasValueProbabilities()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getValueProbabilities());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
