
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.LocalTransformations;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.MiningSchema;
import org.dmg.pmml.Model;
import org.dmg.pmml.ModelStats;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.dmg.pmml.association.Item;
import org.dmg.pmml.association.Itemset;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Since;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SequenceModel", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "miningSchema",
    "modelStats",
    "localTransformations",
    "constraints",
    "items",
    "itemsets",
    "setPredicates",
    "sequences",
    "sequenceRules"
})
@JsonRootName("SequenceModel")
@JsonPropertyOrder({
    "modelName",
    "miningFunction",
    "algorithmName",
    "numberOfTransactions",
    "maxNumberOfItemsPerTransaction",
    "avgNumberOfItemsPerTransaction",
    "numberOfTransactionGroups",
    "maxNumberOfTAsPerTAGroup",
    "avgNumberOfTAsPerTAGroup",
    "minimumSupport",
    "minimumConfidence",
    "lengthLimit",
    "numberOfItems",
    "numberOfSets",
    "numberOfSequences",
    "numberOfRules",
    "timeWindowWidth",
    "minimumTime",
    "maximumTime",
    "scorable",
    "mathContext",
    "extensions",
    "miningSchema",
    "modelStats",
    "localTransformations",
    "constraints",
    "items",
    "itemsets",
    "setPredicates",
    "sequences",
    "sequenceRules"
})
public class SequenceModel
    extends Model
    implements HasExtensions<SequenceModel>
{

    @XmlAttribute(name = "modelName")
    @JsonProperty("modelName")
    private String modelName;
    @XmlAttribute(name = "functionName", required = true)
    @JsonProperty("functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name = "algorithmName")
    @JsonProperty("algorithmName")
    private String algorithmName;
    @XmlAttribute(name = "numberOfTransactions")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfTransactions")
    private Integer numberOfTransactions;
    @XmlAttribute(name = "maxNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maxNumberOfItemsPerTransaction")
    private Integer maxNumberOfItemsPerTransaction;
    @XmlAttribute(name = "avgNumberOfItemsPerTransaction")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("avgNumberOfItemsPerTransaction")
    private Number avgNumberOfItemsPerTransaction;
    @XmlAttribute(name = "numberOfTransactionGroups")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfTransactionGroups")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Integer numberOfTransactionGroups;
    @XmlAttribute(name = "maxNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("maxNumberOfTAsPerTAGroup")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Integer maxNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "avgNumberOfTAsPerTAGroup")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("avgNumberOfTAsPerTAGroup")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Number avgNumberOfTAsPerTAGroup;
    @XmlAttribute(name = "minimumSupport", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumSupport")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Number minimumSupport;
    @XmlAttribute(name = "minimumConfidence", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("minimumConfidence")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Number minimumConfidence;
    @XmlAttribute(name = "lengthLimit")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("lengthLimit")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer lengthLimit;
    @XmlAttribute(name = "numberOfItems", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfItems")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer numberOfItems;
    @XmlAttribute(name = "numberOfSets", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfSets")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer numberOfSets;
    @XmlAttribute(name = "numberOfSequences", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfSequences")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer numberOfSequences;
    @XmlAttribute(name = "numberOfRules", required = true)
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfRules")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer numberOfRules;
    @XmlAttribute(name = "timeWindowWidth")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("timeWindowWidth")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer timeWindowWidth;
    @XmlAttribute(name = "minimumTime")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("minimumTime")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer minimumTime;
    @XmlAttribute(name = "maximumTime")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("maximumTime")
    @org.jpmml.model.annotations.Removed((org.dmg.pmml.Version.PMML_3_1))
    private Integer maximumTime;
    @XmlAttribute(name = "isScorable")
    @JsonProperty("isScorable")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.PMML_4_1), removable = (true))
    private Boolean scorable;
    @XmlAttribute(name = "x-mathContext")
    @JsonProperty("x-mathContext")
    @org.jpmml.model.annotations.Added(value = (org.dmg.pmml.Version.XPMML), removable = (true))
    @Since(("1.3.7"))
    private MathContext mathContext;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MiningSchema", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name = "ModelStats", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ModelStats")
    private ModelStats modelStats;
    @XmlElement(name = "LocalTransformations", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElement(name = "Constraints", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Constraints")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Constraints constraints;
    @XmlElement(name = "Item", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Item")
    private List<Item> items;
    @XmlElement(name = "Itemset", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Itemset")
    private List<Itemset> itemsets;
    @XmlElement(name = "SetPredicate", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SetPredicate")
    private List<SetPredicate> setPredicates;
    @XmlElement(name = "Sequence", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Sequence")
    private List<Sequence> sequences;
    @XmlElement(name = "SequenceRule", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SequenceRule")
    private List<SequenceRule> sequenceRules;
    private final static Boolean DEFAULT_SCORABLE = true;
    private final static long serialVersionUID = 67371272L;

    public SequenceModel() {
    }

    @ValueConstructor
    public SequenceModel(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction,
        @org.jpmml.model.annotations.Property("minimumSupport")
        Number minimumSupport,
        @org.jpmml.model.annotations.Property("minimumConfidence")
        Number minimumConfidence,
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems,
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets,
        @org.jpmml.model.annotations.Property("numberOfSequences")
        Integer numberOfSequences,
        @org.jpmml.model.annotations.Property("numberOfRules")
        Integer numberOfRules,
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema,
        @org.jpmml.model.annotations.Property("sequences")
        List<Sequence> sequences) {
        this.miningFunction = miningFunction;
        this.minimumSupport = minimumSupport;
        this.minimumConfidence = minimumConfidence;
        this.numberOfItems = numberOfItems;
        this.numberOfSets = numberOfSets;
        this.numberOfSequences = numberOfSequences;
        this.numberOfRules = numberOfRules;
        this.miningSchema = miningSchema;
        this.sequences = sequences;
    }

    @Override
    public String getModelName() {
        return modelName;
    }

    @Override
    public SequenceModel setModelName(
        @org.jpmml.model.annotations.Property("modelName")
        String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction requireMiningFunction() {
        if (this.miningFunction == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_MININGFUNCTION);
        }
        return this.miningFunction;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return miningFunction;
    }

    @Override
    public SequenceModel setMiningFunction(
        @org.jpmml.model.annotations.Property("miningFunction")
        MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return algorithmName;
    }

    @Override
    public SequenceModel setAlgorithmName(
        @org.jpmml.model.annotations.Property("algorithmName")
        String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Integer getNumberOfTransactions() {
        return numberOfTransactions;
    }

    public SequenceModel setNumberOfTransactions(
        @org.jpmml.model.annotations.Property("numberOfTransactions")
        Integer numberOfTransactions) {
        this.numberOfTransactions = numberOfTransactions;
        return this;
    }

    public Integer getMaxNumberOfItemsPerTransaction() {
        return maxNumberOfItemsPerTransaction;
    }

    public SequenceModel setMaxNumberOfItemsPerTransaction(
        @org.jpmml.model.annotations.Property("maxNumberOfItemsPerTransaction")
        Integer maxNumberOfItemsPerTransaction) {
        this.maxNumberOfItemsPerTransaction = maxNumberOfItemsPerTransaction;
        return this;
    }

    public Number getAvgNumberOfItemsPerTransaction() {
        return avgNumberOfItemsPerTransaction;
    }

    public SequenceModel setAvgNumberOfItemsPerTransaction(
        @org.jpmml.model.annotations.Property("avgNumberOfItemsPerTransaction")
        Number avgNumberOfItemsPerTransaction) {
        this.avgNumberOfItemsPerTransaction = avgNumberOfItemsPerTransaction;
        return this;
    }

    public Integer getNumberOfTransactionGroups() {
        return numberOfTransactionGroups;
    }

    public SequenceModel setNumberOfTransactionGroups(
        @org.jpmml.model.annotations.Property("numberOfTransactionGroups")
        Integer numberOfTransactionGroups) {
        this.numberOfTransactionGroups = numberOfTransactionGroups;
        return this;
    }

    public Integer getMaxNumberOfTAsPerTAGroup() {
        return maxNumberOfTAsPerTAGroup;
    }

    public SequenceModel setMaxNumberOfTAsPerTAGroup(
        @org.jpmml.model.annotations.Property("maxNumberOfTAsPerTAGroup")
        Integer maxNumberOfTAsPerTAGroup) {
        this.maxNumberOfTAsPerTAGroup = maxNumberOfTAsPerTAGroup;
        return this;
    }

    public Number getAvgNumberOfTAsPerTAGroup() {
        return avgNumberOfTAsPerTAGroup;
    }

    public SequenceModel setAvgNumberOfTAsPerTAGroup(
        @org.jpmml.model.annotations.Property("avgNumberOfTAsPerTAGroup")
        Number avgNumberOfTAsPerTAGroup) {
        this.avgNumberOfTAsPerTAGroup = avgNumberOfTAsPerTAGroup;
        return this;
    }

    public Number requireMinimumSupport() {
        if (this.minimumSupport == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_MINIMUMSUPPORT);
        }
        return this.minimumSupport;
    }

    public Number getMinimumSupport() {
        return minimumSupport;
    }

    public SequenceModel setMinimumSupport(
        @org.jpmml.model.annotations.Property("minimumSupport")
        Number minimumSupport) {
        this.minimumSupport = minimumSupport;
        return this;
    }

    public Number requireMinimumConfidence() {
        if (this.minimumConfidence == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_MINIMUMCONFIDENCE);
        }
        return this.minimumConfidence;
    }

    public Number getMinimumConfidence() {
        return minimumConfidence;
    }

    public SequenceModel setMinimumConfidence(
        @org.jpmml.model.annotations.Property("minimumConfidence")
        Number minimumConfidence) {
        this.minimumConfidence = minimumConfidence;
        return this;
    }

    public Integer getLengthLimit() {
        return lengthLimit;
    }

    public SequenceModel setLengthLimit(
        @org.jpmml.model.annotations.Property("lengthLimit")
        Integer lengthLimit) {
        this.lengthLimit = lengthLimit;
        return this;
    }

    public Integer requireNumberOfItems() {
        if (this.numberOfItems == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFITEMS);
        }
        return this.numberOfItems;
    }

    public Integer getNumberOfItems() {
        return numberOfItems;
    }

    public SequenceModel setNumberOfItems(
        @org.jpmml.model.annotations.Property("numberOfItems")
        Integer numberOfItems) {
        this.numberOfItems = numberOfItems;
        return this;
    }

    public Integer requireNumberOfSets() {
        if (this.numberOfSets == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFSETS);
        }
        return this.numberOfSets;
    }

    public Integer getNumberOfSets() {
        return numberOfSets;
    }

    public SequenceModel setNumberOfSets(
        @org.jpmml.model.annotations.Property("numberOfSets")
        Integer numberOfSets) {
        this.numberOfSets = numberOfSets;
        return this;
    }

    public Integer requireNumberOfSequences() {
        if (this.numberOfSequences == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFSEQUENCES);
        }
        return this.numberOfSequences;
    }

    public Integer getNumberOfSequences() {
        return numberOfSequences;
    }

    public SequenceModel setNumberOfSequences(
        @org.jpmml.model.annotations.Property("numberOfSequences")
        Integer numberOfSequences) {
        this.numberOfSequences = numberOfSequences;
        return this;
    }

    public Integer requireNumberOfRules() {
        if (this.numberOfRules == null) {
            throw new MissingAttributeException(this, PMMLAttributes.SEQUENCEMODEL_NUMBEROFRULES);
        }
        return this.numberOfRules;
    }

    public Integer getNumberOfRules() {
        return numberOfRules;
    }

    public SequenceModel setNumberOfRules(
        @org.jpmml.model.annotations.Property("numberOfRules")
        Integer numberOfRules) {
        this.numberOfRules = numberOfRules;
        return this;
    }

    public Integer getTimeWindowWidth() {
        return timeWindowWidth;
    }

    public SequenceModel setTimeWindowWidth(
        @org.jpmml.model.annotations.Property("timeWindowWidth")
        Integer timeWindowWidth) {
        this.timeWindowWidth = timeWindowWidth;
        return this;
    }

    public Integer getMinimumTime() {
        return minimumTime;
    }

    public SequenceModel setMinimumTime(
        @org.jpmml.model.annotations.Property("minimumTime")
        Integer minimumTime) {
        this.minimumTime = minimumTime;
        return this;
    }

    public Integer getMaximumTime() {
        return maximumTime;
    }

    public SequenceModel setMaximumTime(
        @org.jpmml.model.annotations.Property("maximumTime")
        Integer maximumTime) {
        this.maximumTime = maximumTime;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (scorable == null) {
            return DEFAULT_SCORABLE;
        } else {
            return scorable;
        }
    }

    @Override
    public SequenceModel setScorable(
        @org.jpmml.model.annotations.Property("scorable")
        Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (mathContext == null) {
            return MathContext.DOUBLE;
        } else {
            return mathContext;
        }
    }

    @Override
    public SequenceModel setMathContext(
        @org.jpmml.model.annotations.Property("mathContext")
        MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SequenceModel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema requireMiningSchema() {
        if (this.miningSchema == null) {
            throw new MissingElementException(this, PMMLElements.SEQUENCEMODEL_MININGSCHEMA);
        }
        return this.miningSchema;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return miningSchema;
    }

    @Override
    public SequenceModel setMiningSchema(
        @org.jpmml.model.annotations.Property("miningSchema")
        MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return modelStats;
    }

    @Override
    public SequenceModel setModelStats(
        @org.jpmml.model.annotations.Property("modelStats")
        ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return localTransformations;
    }

    @Override
    public SequenceModel setLocalTransformations(
        @org.jpmml.model.annotations.Property("localTransformations")
        LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public Constraints getConstraints() {
        return constraints;
    }

    public SequenceModel setConstraints(
        @org.jpmml.model.annotations.Property("constraints")
        Constraints constraints) {
        this.constraints = constraints;
        return this;
    }

    public boolean hasItems() {
        return ((this.items!= null)&&(!this.items.isEmpty()));
    }

    public List<Item> getItems() {
        if (items == null) {
            items = new ArrayList<Item>();
        }
        return this.items;
    }

    public SequenceModel addItems(Item... items) {
        getItems().addAll(Arrays.asList(items));
        return this;
    }

    public boolean hasItemsets() {
        return ((this.itemsets!= null)&&(!this.itemsets.isEmpty()));
    }

    public List<Itemset> getItemsets() {
        if (itemsets == null) {
            itemsets = new ArrayList<Itemset>();
        }
        return this.itemsets;
    }

    public SequenceModel addItemsets(Itemset... itemsets) {
        getItemsets().addAll(Arrays.asList(itemsets));
        return this;
    }

    public boolean hasSetPredicates() {
        return ((this.setPredicates!= null)&&(!this.setPredicates.isEmpty()));
    }

    public List<SetPredicate> getSetPredicates() {
        if (setPredicates == null) {
            setPredicates = new ArrayList<SetPredicate>();
        }
        return this.setPredicates;
    }

    public SequenceModel addSetPredicates(SetPredicate... setPredicates) {
        getSetPredicates().addAll(Arrays.asList(setPredicates));
        return this;
    }

    public boolean hasSequences() {
        return ((this.sequences!= null)&&(!this.sequences.isEmpty()));
    }

    public List<Sequence> requireSequences() {
        if ((this.sequences == null)||this.sequences.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.SEQUENCEMODEL_SEQUENCES);
        }
        return this.sequences;
    }

    public List<Sequence> getSequences() {
        if (sequences == null) {
            sequences = new ArrayList<Sequence>();
        }
        return this.sequences;
    }

    public SequenceModel addSequences(Sequence... sequences) {
        getSequences().addAll(Arrays.asList(sequences));
        return this;
    }

    public boolean hasSequenceRules() {
        return ((this.sequenceRules!= null)&&(!this.sequenceRules.isEmpty()));
    }

    public List<SequenceRule> getSequenceRules() {
        if (sequenceRules == null) {
            sequenceRules = new ArrayList<SequenceRule>();
        }
        return this.sequenceRules;
    }

    public SequenceModel addSequenceRules(SequenceRule... sequenceRules) {
        getSequenceRules().addAll(Arrays.asList(sequenceRules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getMiningSchema(), getModelStats(), getLocalTransformations(), getConstraints());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItems()) {
                status = PMMLObject.traverse(visitor, getItems());
            }
            if ((status == VisitorAction.CONTINUE)&&hasItemsets()) {
                status = PMMLObject.traverse(visitor, getItemsets());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSetPredicates()) {
                status = PMMLObject.traverse(visitor, getSetPredicates());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequences()) {
                status = PMMLObject.traverse(visitor, getSequences());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSequenceRules()) {
                status = PMMLObject.traverse(visitor, getSequenceRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
