
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Decisions", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "decisions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("Decisions")
@JsonPropertyOrder({
    "businessProblem",
    "description",
    "extensions",
    "decisions"
})
public class Decisions
    extends org.dmg.pmml.PMMLObject
    implements Iterable<Decision> , HasExtensions<Decisions>
{

    @XmlAttribute(name = "businessProblem")
    @JsonProperty("businessProblem")
    private String businessProblem;
    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Decision", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Decision")
    private List<Decision> decisions;
    private final static long serialVersionUID = 67371269L;

    public Decisions() {
    }

    @ValueConstructor
    public Decisions(
        @org.jpmml.model.annotations.Property("decisions")
        List<Decision> decisions) {
        this.decisions = decisions;
    }

    public String getBusinessProblem() {
        return businessProblem;
    }

    public Decisions setBusinessProblem(
        @org.jpmml.model.annotations.Property("businessProblem")
        String businessProblem) {
        this.businessProblem = businessProblem;
        return this;
    }

    public String getDescription() {
        return description;
    }

    public Decisions setDescription(
        @org.jpmml.model.annotations.Property("description")
        String description) {
        this.description = description;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Decisions addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<Decision> iterator() {
        return requireDecisions().iterator();
    }

    public boolean hasDecisions() {
        return ((this.decisions!= null)&&(!this.decisions.isEmpty()));
    }

    public List<Decision> requireDecisions() {
        if ((this.decisions == null)||this.decisions.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.DECISIONS_DECISIONS);
        }
        return this.decisions;
    }

    public List<Decision> getDecisions() {
        if (decisions == null) {
            decisions = new ArrayList<Decision>();
        }
        return this.decisions;
    }

    public Decisions addDecisions(Decision... decisions) {
        getDecisions().addAll(Arrays.asList(decisions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDecisions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDecisions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
