
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Interval", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Interval")
@JsonPropertyOrder({
    "closure",
    "leftMargin",
    "rightMargin",
    "extensions"
})
public class Interval
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Interval>
{

    @XmlAttribute(name = "closure", required = true)
    @JsonProperty("closure")
    private Interval.Closure closure;
    @XmlAttribute(name = "leftMargin")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("leftMargin")
    private Number leftMargin;
    @XmlAttribute(name = "rightMargin")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("rightMargin")
    private Number rightMargin;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371269L;

    public Interval() {
    }

    @ValueConstructor
    public Interval(
        @org.jpmml.model.annotations.Property("closure")
        Interval.Closure closure) {
        this.closure = closure;
    }

    public Interval.Closure requireClosure() {
        if (this.closure == null) {
            throw new MissingAttributeException(this, PMMLAttributes.INTERVAL_CLOSURE);
        }
        return this.closure;
    }

    public Interval.Closure getClosure() {
        return closure;
    }

    public Interval setClosure(
        @org.jpmml.model.annotations.Property("closure")
        Interval.Closure closure) {
        this.closure = closure;
        return this;
    }

    public Number getLeftMargin() {
        return leftMargin;
    }

    public Interval setLeftMargin(
        @org.jpmml.model.annotations.Property("leftMargin")
        Number leftMargin) {
        this.leftMargin = leftMargin;
        return this;
    }

    public Number getRightMargin() {
        return rightMargin;
    }

    public Interval setRightMargin(
        @org.jpmml.model.annotations.Property("rightMargin")
        Number rightMargin) {
        this.rightMargin = rightMargin;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Interval addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Closure
        implements StringValue<Interval.Closure>
    {

        @XmlEnumValue("openClosed")
        @JsonProperty("openClosed")
        OPEN_CLOSED("openClosed"),
        @XmlEnumValue("openOpen")
        @JsonProperty("openOpen")
        OPEN_OPEN("openOpen"),
        @XmlEnumValue("closedOpen")
        @JsonProperty("closedOpen")
        CLOSED_OPEN("closedOpen"),
        @XmlEnumValue("closedClosed")
        @JsonProperty("closedClosed")
        CLOSED_CLOSED("closedClosed");
        private final String value;

        Closure(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Interval.Closure fromValue(String v) {
            for (Interval.Closure c: Interval.Closure.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
