/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.model;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.naive_bayes.PMMLElements;
import org.dmg.pmml.text.PMMLAttributes;
import org.w3c.dom.Element;
import org.xml.sax.Locator;

public class ReflectionUtil {
    private static final ConcurrentMap<Class<?>, List<Field>> classFields = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Map<Field, Method>> classGetterMethods = new ConcurrentHashMap();
    private static final Set<Class<?>> primitiveWrapperClasses = new HashSet<Class>(Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Character.class));

    private ReflectionUtil() {
    }

    public static boolean isFieldName(Field field) {
        XmlJavaTypeAdapter xmlJavaTypeAdapter = field.getAnnotation(XmlJavaTypeAdapter.class);
        if (xmlJavaTypeAdapter != null) {
            return Objects.equals(FieldNameAdapter.class, xmlJavaTypeAdapter.value());
        }
        return false;
    }

    public static int hashCode(Object object) {
        if (object instanceof Element) {
            return ReflectionUtil.hashCode((Element)object);
        }
        if (object instanceof PMMLObject) {
            return ReflectionUtil.hashCode((PMMLObject)object);
        }
        return Objects.hashCode(object);
    }

    public static int hashCode(Element element) {
        int result = 0;
        result += 31 * result + Objects.hashCode(element.getNamespaceURI());
        result += 31 * result + Objects.hashCode(element.getLocalName());
        result += 31 * result + Objects.hashCode(element.getTextContent());
        return result;
    }

    public static int hashCode(PMMLObject object) {
        int result = 0;
        Map<Field, Method> getterMethods = ReflectionUtil.getGetterMethods(object.getClass());
        Set<Map.Entry<Field, Method>> entries = getterMethods.entrySet();
        for (Map.Entry entry : entries) {
            Field field = (Field)entry.getKey();
            Method getterMethod = (Method)entry.getValue();
            Class<?> fieldType = field.getType();
            if (Objects.equals(Locator.class, fieldType)) continue;
            Object value = Objects.equals(List.class, fieldType) ? ReflectionUtil.getFieldValue(field, object) : ReflectionUtil.getGetterMethodValue(getterMethod, object);
            if ((value = ReflectionUtil.standardizeValue(value)) instanceof List) {
                List values = (List)value;
                int max = values.size();
                for (int i = 0; i < max; ++i) {
                    result += 31 * result + ReflectionUtil.hashCode(values.get(i));
                }
                continue;
            }
            result += 31 * result + ReflectionUtil.hashCode(value);
        }
        return result;
    }

    public static boolean equals(Object left, Object right) {
        if (left instanceof Element && right instanceof Element) {
            return ReflectionUtil.equals((Element)left, (Element)right);
        }
        if (left instanceof PMMLObject && right instanceof PMMLObject) {
            return ReflectionUtil.equals((PMMLObject)left, (PMMLObject)right);
        }
        return Objects.equals(left, right);
    }

    public static boolean equals(Element left, Element right) {
        if (!Objects.equals(left.getClass(), right.getClass())) {
            return false;
        }
        return Objects.equals(left.getNamespaceURI(), right.getNamespaceURI()) && Objects.equals(left.getLocalName(), right.getLocalName()) && Objects.equals(left.getTextContent(), right.getTextContent());
    }

    public static boolean equals(PMMLObject left, PMMLObject right) {
        if (!Objects.equals(left.getClass(), right.getClass())) {
            return false;
        }
        Map<Field, Method> getterMethods = ReflectionUtil.getGetterMethods(left.getClass());
        Set<Map.Entry<Field, Method>> entries = getterMethods.entrySet();
        for (Map.Entry entry : entries) {
            boolean equals;
            Object rightValue;
            Object leftValue;
            Field field = (Field)entry.getKey();
            Method getterMethod = (Method)entry.getValue();
            Class<?> fieldType = field.getType();
            if (Objects.equals(Locator.class, fieldType)) continue;
            if (Objects.equals(List.class, fieldType)) {
                leftValue = ReflectionUtil.getFieldValue(field, left);
                rightValue = ReflectionUtil.getFieldValue(field, right);
            } else {
                leftValue = ReflectionUtil.getGetterMethodValue(getterMethod, left);
                rightValue = ReflectionUtil.getGetterMethodValue(getterMethod, right);
            }
            leftValue = ReflectionUtil.standardizeValue(leftValue);
            rightValue = ReflectionUtil.standardizeValue(rightValue);
            if (leftValue instanceof List && rightValue instanceof List) {
                List leftValues = (List)leftValue;
                List rightValues = (List)rightValue;
                if (leftValues.size() == rightValues.size()) {
                    equals = true;
                    int max = leftValues.size();
                    for (int i = 0; i < max && (equals &= ReflectionUtil.equals(leftValues.get(i), rightValues.get(i))); ++i) {
                    }
                } else {
                    equals = false;
                }
            } else {
                equals = ReflectionUtil.equals(leftValue, rightValue);
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public static <E extends PMMLObject> void copyState(E from, E to) {
        Class<?> toClazz;
        Class<?> fromClazz = from.getClass();
        if (!fromClazz.isAssignableFrom(toClazz = to.getClass())) {
            throw new IllegalArgumentException();
        }
        List<Field> fields = ReflectionUtil.getFields(fromClazz);
        for (Field field : fields) {
            E value = ReflectionUtil.getFieldValue(field, from);
            ReflectionUtil.setFieldValue(field, to, value);
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        while (clazz != null) {
            try {
                Field field = clazz.getDeclaredField(name);
                if (!ReflectionUtil.isValidInstanceField(field)) {
                    throw new IllegalArgumentException(name);
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException(new NoSuchFieldException(name));
    }

    public static List<Field> getFields(Class<?> clazz) {
        List<Field> result = (List<Field>)classFields.get(clazz);
        if (result == null) {
            result = ReflectionUtil.loadFields(clazz);
            classFields.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static List<Field> getAttributeFields() {
        List<Class<?>> clazzes = Arrays.asList(org.dmg.pmml.PMMLAttributes.class, org.dmg.pmml.anomaly_detection.PMMLAttributes.class, org.dmg.pmml.association.PMMLAttributes.class, org.dmg.pmml.baseline.PMMLAttributes.class, org.dmg.pmml.bayesian_network.PMMLAttributes.class, org.dmg.pmml.clustering.PMMLAttributes.class, org.dmg.pmml.gaussian_process.PMMLAttributes.class, org.dmg.pmml.general_regression.PMMLAttributes.class, org.dmg.pmml.mining.PMMLAttributes.class, org.dmg.pmml.naive_bayes.PMMLAttributes.class, org.dmg.pmml.nearest_neighbor.PMMLAttributes.class, org.dmg.pmml.neural_network.PMMLAttributes.class, org.dmg.pmml.regression.PMMLAttributes.class, org.dmg.pmml.rule_set.PMMLAttributes.class, org.dmg.pmml.scorecard.PMMLAttributes.class, org.dmg.pmml.sequence.PMMLAttributes.class, org.dmg.pmml.support_vector_machine.PMMLAttributes.class, PMMLAttributes.class, org.dmg.pmml.time_series.PMMLAttributes.class, org.dmg.pmml.tree.PMMLAttributes.class);
        return ReflectionUtil.getClassConstants(clazzes);
    }

    public static List<Field> getElementFields() {
        List<Class<?>> clazzes = Arrays.asList(org.dmg.pmml.PMMLElements.class, org.dmg.pmml.anomaly_detection.PMMLElements.class, org.dmg.pmml.association.PMMLElements.class, org.dmg.pmml.baseline.PMMLElements.class, org.dmg.pmml.bayesian_network.PMMLElements.class, org.dmg.pmml.clustering.PMMLElements.class, org.dmg.pmml.gaussian_process.PMMLElements.class, org.dmg.pmml.general_regression.PMMLElements.class, org.dmg.pmml.mining.PMMLElements.class, PMMLElements.class, org.dmg.pmml.nearest_neighbor.PMMLElements.class, org.dmg.pmml.neural_network.PMMLElements.class, org.dmg.pmml.regression.PMMLElements.class, org.dmg.pmml.rule_set.PMMLElements.class, org.dmg.pmml.scorecard.PMMLElements.class, org.dmg.pmml.sequence.PMMLElements.class, org.dmg.pmml.support_vector_machine.PMMLElements.class, org.dmg.pmml.text.PMMLElements.class, org.dmg.pmml.time_series.PMMLElements.class, org.dmg.pmml.tree.PMMLElements.class);
        return ReflectionUtil.getClassConstants(clazzes);
    }

    public static Method getGetterMethod(Field field) {
        Class<?> clazz = field.getDeclaringClass();
        Map<Field, Method> getterMethods = ReflectionUtil.getGetterMethods(clazz);
        Method getterMethod = getterMethods.get(field);
        if (getterMethod == null) {
            throw new RuntimeException(new NoSuchMethodException());
        }
        return getterMethod;
    }

    public static Map<Field, Method> getGetterMethods(Class<?> clazz) {
        Map<Field, Method> result = (Map<Field, Method>)classGetterMethods.get(clazz);
        if (result == null) {
            result = ReflectionUtil.loadGetterMethods(clazz);
            classGetterMethods.putIfAbsent(clazz, result);
        }
        return result;
    }

    public static <E> E getFieldValue(Field field, Object object) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            return (E)field.get(object);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static void setFieldValue(Field field, Object object, Object value) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static <E> E getGetterMethodValue(Method method, Object object) {
        try {
            return (E)method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return primitiveWrapperClasses.contains(clazz);
    }

    public static boolean isDefaultValue(Object value) {
        if (value instanceof Boolean) {
            return Objects.equals(Boolean.FALSE, value);
        }
        if (value instanceof Character) {
            Character character = (Character)value;
            return character.charValue() == '\u0000';
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return Double.compare(number.doubleValue(), 0.0) == 0;
        }
        return false;
    }

    public static List<Field> getClassConstants(List<Class<?>> clazzes) {
        ArrayList<Field> result = new ArrayList<Field>();
        try {
            for (Class<?> clazz : clazzes) {
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    result.add((Field)field.get(null));
                }
            }
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        return result;
    }

    private static Object standardizeValue(Object value) {
        List list;
        if (value instanceof List && (list = (List)value).isEmpty()) {
            return null;
        }
        return value;
    }

    private static List<Field> loadFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                if (!ReflectionUtil.isValidInstanceField(field)) continue;
                result.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return Collections.unmodifiableList(result);
    }

    private static Map<Field, Method> loadGetterMethods(Class<?> clazz) {
        Method[] methods;
        LinkedHashMap<Field, Method> result = new LinkedHashMap<Field, Method>();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        List<Field> fields = ReflectionUtil.getFields(clazz);
        for (Field field : fields) {
            String name = field.getName();
            fieldMap.put(name.toLowerCase(), field);
        }
        for (Method method : methods = clazz.getMethods()) {
            Field field;
            String name = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (name.startsWith("is")) {
                name = name.substring("is".length());
            } else {
                if (!name.startsWith("get")) continue;
                name = name.substring("get".length());
            }
            if (parameterTypes.length != 0 || (field = (Field)fieldMap.get(name.toLowerCase())) == null) continue;
            result.put(field, method);
        }
        return result;
    }

    private static boolean isValidInstanceField(Field field) {
        if (ReflectionUtil.hasValidName(field)) {
            int modifiers = field.getModifiers();
            return !Modifier.isStatic(modifiers);
        }
        return false;
    }

    private static boolean hasValidName(Field field) {
        String name = field.getName();
        if (name.length() > 0) {
            return Character.isLetterOrDigit(name.charAt(0));
        }
        return false;
    }
}

