
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Application", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Application")
@JsonPropertyOrder({
    "name",
    "version",
    "extensions"
})
public class Application
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Application>
{

    @XmlAttribute(name = "name", required = true)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "version")
    @JsonProperty("version")
    private String version;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371269L;

    public Application() {
    }

    @ValueConstructor
    public Application(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
    }

    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.APPLICATION_NAME);
        }
        return this.name;
    }

    public String getName() {
        return name;
    }

    public Application setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public String getVersion() {
        return version;
    }

    public Application setVersion(
        @org.jpmml.model.annotations.Property("version")
        String version) {
        this.version = version;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Application addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
