
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "MultivariateStats", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "multivariateStats"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
@JsonRootName("MultivariateStats")
@JsonPropertyOrder({
    "targetCategory",
    "extensions",
    "multivariateStats"
})
public class MultivariateStats
    extends Stats
    implements Iterable<MultivariateStat> , HasExtensions<MultivariateStats>
{

    @XmlAttribute(name = "targetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("targetCategory")
    private Object targetCategory;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "MultivariateStat", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("MultivariateStat")
    private List<MultivariateStat> multivariateStats;
    private final static long serialVersionUID = 67371269L;

    public MultivariateStats() {
    }

    @ValueConstructor
    public MultivariateStats(
        @org.jpmml.model.annotations.Property("multivariateStats")
        List<MultivariateStat> multivariateStats) {
        this.multivariateStats = multivariateStats;
    }

    public Object getTargetCategory() {
        return targetCategory;
    }

    public MultivariateStats setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        Object targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MultivariateStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<MultivariateStat> iterator() {
        return requireMultivariateStats().iterator();
    }

    public boolean hasMultivariateStats() {
        return ((this.multivariateStats!= null)&&(!this.multivariateStats.isEmpty()));
    }

    public List<MultivariateStat> requireMultivariateStats() {
        if ((this.multivariateStats == null)||this.multivariateStats.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.MULTIVARIATESTATS_MULTIVARIATESTATS);
        }
        return this.multivariateStats;
    }

    public List<MultivariateStat> getMultivariateStats() {
        if (multivariateStats == null) {
            multivariateStats = new ArrayList<MultivariateStat>();
        }
        return this.multivariateStats;
    }

    public MultivariateStats addMultivariateStats(MultivariateStat... multivariateStats) {
        getMultivariateStats().addAll(Arrays.asList(multivariateStats));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasMultivariateStats()) {
                status = PMMLObject.traverse(visitor, getMultivariateStats());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
