
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.annotations.Property;

@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonPropertyOrder({
    "description",
    "gamma",
    "extensions"
})
public class RadialBasisKernel
    extends Kernel
    implements HasExtensions<RadialBasisKernel>
{

    @XmlAttribute(name = "description")
    @JsonProperty("description")
    private String description;
    @XmlAttribute(name = "gamma")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("gamma")
    private Number gamma;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static Number DEFAULT_GAMMA = new RealNumberAdapter().unmarshal("1");
    private final static long serialVersionUID = 67371269L;

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public RadialBasisKernel setDescription(
        @Property("description")
        String description) {
        this.description = description;
        return this;
    }

    public Number getGamma() {
        if (gamma == null) {
            return DEFAULT_GAMMA;
        } else {
            return gamma;
        }
    }

    public RadialBasisKernel setGamma(
        @Property("gamma")
        Number gamma) {
        this.gamma = gamma;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public RadialBasisKernel addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
