
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Delimiter", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Delimiter")
@JsonPropertyOrder({
    "delimiter",
    "gap",
    "extensions"
})
public class Delimiter
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Delimiter>
{

    @XmlAttribute(name = "delimiter", required = true)
    @JsonProperty("delimiter")
    private Delimiter.TimeWindow delimiter;
    @XmlAttribute(name = "gap", required = true)
    @JsonProperty("gap")
    private Delimiter.Gap gap;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    private final static long serialVersionUID = 67371270L;

    public Delimiter() {
    }

    @ValueConstructor
    public Delimiter(
        @org.jpmml.model.annotations.Property("delimiter")
        Delimiter.TimeWindow delimiter,
        @org.jpmml.model.annotations.Property("gap")
        Delimiter.Gap gap) {
        this.delimiter = delimiter;
        this.gap = gap;
    }

    public Delimiter.TimeWindow requireDelimiter() {
        if (this.delimiter == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DELIMITER_DELIMITER);
        }
        return this.delimiter;
    }

    public Delimiter.TimeWindow getDelimiter() {
        return delimiter;
    }

    public Delimiter setDelimiter(
        @org.jpmml.model.annotations.Property("delimiter")
        Delimiter.TimeWindow delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public Delimiter.Gap requireGap() {
        if (this.gap == null) {
            throw new MissingAttributeException(this, PMMLAttributes.DELIMITER_GAP);
        }
        return this.gap;
    }

    public Delimiter.Gap getGap() {
        return gap;
    }

    public Delimiter setGap(
        @org.jpmml.model.annotations.Property("gap")
        Delimiter.Gap gap) {
        this.gap = gap;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Delimiter addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Gap
        implements StringValue<Delimiter.Gap>
    {

        @XmlEnumValue("true")
        @JsonProperty("true")
        TRUE("true"),
        @XmlEnumValue("false")
        @JsonProperty("false")
        FALSE("false"),
        @XmlEnumValue("unknown")
        @JsonProperty("unknown")
        UNKNOWN("unknown");
        private final String value;

        Gap(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Delimiter.Gap fromValue(String v) {
            for (Delimiter.Gap c: Delimiter.Gap.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum TimeWindow
        implements StringValue<Delimiter.TimeWindow>
    {

        @XmlEnumValue("sameTimeWindow")
        @JsonProperty("sameTimeWindow")
        SAME_TIME_WINDOW("sameTimeWindow"),
        @XmlEnumValue("acrossTimeWindows")
        @JsonProperty("acrossTimeWindows")
        ACROSS_TIME_WINDOWS("acrossTimeWindows");
        private final String value;

        TimeWindow(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Delimiter.TimeWindow fromValue(String v) {
            for (Delimiter.TimeWindow c: Delimiter.TimeWindow.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
