
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "expressions"
})
@JsonRootName("Apply")
@JsonPropertyOrder({
    "function",
    "mapMissingTo",
    "defaultValue",
    "invalidValueTreatment",
    "extensions",
    "expressions"
})
public class Apply
    extends org.dmg.pmml.Expression
    implements HasDefaultValue<Apply, Object> , HasExtensions<Apply> , HasMapMissingTo<Apply, Object>
{

    @XmlAttribute(name = "function", required = true)
    @Required((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("function")
    private String function;
    @XmlAttribute(name = "mapMissingTo")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("mapMissingTo")
    private Object mapMissingTo;
    @XmlAttribute(name = "defaultValue")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_2))
    @JsonProperty("defaultValue")
    private Object defaultValue;
    @XmlAttribute(name = "invalidValueTreatment")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    @JsonProperty("invalidValueTreatment")
    private InvalidValueTreatmentMethod invalidValueTreatment;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "Constant", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Constant.class),
        @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.FieldRef.class),
        @XmlElement(name = "NormContinuous", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormContinuous.class),
        @XmlElement(name = "NormDiscrete", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.NormDiscrete.class),
        @XmlElement(name = "Discretize", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Discretize.class),
        @XmlElement(name = "MapValues", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.MapValues.class),
        @XmlElement(name = "TextIndex", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.TextIndex.class),
        @XmlElement(name = "Apply", namespace = "http://www.dmg.org/PMML-4_4", type = Apply.class),
        @XmlElement(name = "Aggregate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Aggregate.class),
        @XmlElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.Lag.class)
    })
    @JsonProperty("Expression")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "Constant", value = org.dmg.pmml.Constant.class),
        @JsonSubTypes.Type(name = "FieldRef", value = org.dmg.pmml.FieldRef.class),
        @JsonSubTypes.Type(name = "NormContinuous", value = org.dmg.pmml.NormContinuous.class),
        @JsonSubTypes.Type(name = "NormDiscrete", value = org.dmg.pmml.NormDiscrete.class),
        @JsonSubTypes.Type(name = "Discretize", value = org.dmg.pmml.Discretize.class),
        @JsonSubTypes.Type(name = "MapValues", value = org.dmg.pmml.MapValues.class),
        @JsonSubTypes.Type(name = "TextIndex", value = org.dmg.pmml.TextIndex.class),
        @JsonSubTypes.Type(name = "Apply", value = org.dmg.pmml.Apply.class),
        @JsonSubTypes.Type(name = "Aggregate", value = org.dmg.pmml.Aggregate.class),
        @JsonSubTypes.Type(name = "Lag", value = org.dmg.pmml.Lag.class)
    })
    private List<org.dmg.pmml.Expression> expressions;
    private final static long serialVersionUID = 67371270L;

    public Apply() {
    }

    @ValueConstructor
    public Apply(
        @org.jpmml.model.annotations.Property("function")
        String function) {
        this.function = function;
    }

    public String requireFunction() {
        if (this.function == null) {
            throw new MissingAttributeException(this, PMMLAttributes.APPLY_FUNCTION);
        }
        return this.function;
    }

    public String getFunction() {
        return function;
    }

    public Apply setFunction(
        @org.jpmml.model.annotations.Property("function")
        String function) {
        this.function = function;
        return this;
    }

    @Override
    public Object getMapMissingTo() {
        return mapMissingTo;
    }

    @Override
    public Apply setMapMissingTo(
        @org.jpmml.model.annotations.Property("mapMissingTo")
        Object mapMissingTo) {
        this.mapMissingTo = mapMissingTo;
        return this;
    }

    @Override
    public Object getDefaultValue() {
        return defaultValue;
    }

    @Override
    public Apply setDefaultValue(
        @org.jpmml.model.annotations.Property("defaultValue")
        Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public InvalidValueTreatmentMethod getInvalidValueTreatment() {
        if (invalidValueTreatment == null) {
            return InvalidValueTreatmentMethod.RETURN_INVALID;
        } else {
            return invalidValueTreatment;
        }
    }

    public Apply setInvalidValueTreatment(
        @org.jpmml.model.annotations.Property("invalidValueTreatment")
        InvalidValueTreatmentMethod invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Apply addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasExpressions() {
        return ((this.expressions!= null)&&(!this.expressions.isEmpty()));
    }

    public List<org.dmg.pmml.Expression> getExpressions() {
        if (expressions == null) {
            expressions = new ArrayList<org.dmg.pmml.Expression>();
        }
        return this.expressions;
    }

    public Apply addExpressions(org.dmg.pmml.Expression... expressions) {
        getExpressions().addAll(Arrays.asList(expressions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasExpressions()) {
                status = PMMLObject.traverse(visitor, getExpressions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
