
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ParameterField", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "")
@JsonRootName("ParameterField")
@JsonPropertyOrder({
    "name",
    "opType",
    "dataType",
    "displayName"
})
public class ParameterField
    extends Field<ParameterField>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "optype")
    @JsonProperty("optype")
    private OpType opType;
    @XmlAttribute(name = "dataType")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    @JsonProperty("dataType")
    private DataType dataType;
    @XmlAttribute(name = "displayName")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    @JsonProperty("displayName")
    private String displayName;
    private final static long serialVersionUID = 67371270L;

    public ParameterField() {
    }

    @ValueConstructor
    public ParameterField(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
    }

    @Override
    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PARAMETERFIELD_NAME);
        }
        return this.name;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public ParameterField setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    @Override
    public OpType requireOpType() {
        if (this.opType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PARAMETERFIELD_OPTYPE);
        }
        return this.opType;
    }

    @Override
    public OpType getOpType() {
        return opType;
    }

    @Override
    public ParameterField setOpType(
        @org.jpmml.model.annotations.Property("opType")
        OpType opType) {
        this.opType = opType;
        return this;
    }

    @Override
    public DataType requireDataType() {
        if (this.dataType == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PARAMETERFIELD_DATATYPE);
        }
        return this.dataType;
    }

    @Override
    public DataType getDataType() {
        return dataType;
    }

    @Override
    public ParameterField setDataType(
        @org.jpmml.model.annotations.Property("dataType")
        DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @Override
    public String getDisplayName() {
        return displayName;
    }

    @Override
    public ParameterField setDisplayName(
        @org.jpmml.model.annotations.Property("displayName")
        String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
