
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ContinuousNode", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "derivedFields",
    "content"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
@JsonRootName("ContinuousNode")
@JsonPropertyOrder({
    "name",
    "count",
    "extensions",
    "derivedFields",
    "content"
})
public class ContinuousNode
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ContinuousNode>
{

    @XmlAttribute(name = "name", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("name")
    private String name;
    @XmlAttribute(name = "count")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("count")
    private Number count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "DerivedField", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("DerivedField")
    private List<DerivedField> derivedFields;
    @XmlElements({
        @XmlElement(name = "ContinuousConditionalProbability", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.ContinuousConditionalProbability.class),
        @XmlElement(name = "ContinuousDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.bayesian_network.ContinuousDistribution.class)
    })
    @JsonProperty("content")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "ContinuousConditionalProbability", value = org.dmg.pmml.bayesian_network.ContinuousConditionalProbability.class),
        @JsonSubTypes.Type(name = "ContinuousDistribution", value = org.dmg.pmml.bayesian_network.ContinuousDistribution.class)
    })
    private List<org.dmg.pmml.PMMLObject> content;
    private final static long serialVersionUID = 67371270L;

    public ContinuousNode() {
    }

    @ValueConstructor
    public ContinuousNode(
        @org.jpmml.model.annotations.Property("name")
        String name,
        @org.jpmml.model.annotations.Property("content")
        List<org.dmg.pmml.PMMLObject> content) {
        this.name = name;
        this.content = content;
    }

    @AlternateValueConstructor
    public ContinuousNode(Field<?> nameField, List<org.dmg.pmml.PMMLObject> content) {
        this(((nameField!= null)?nameField.requireName():null), content);
    }

    public String requireName() {
        if (this.name == null) {
            throw new MissingAttributeException(this, PMMLAttributes.CONTINUOUSNODE_NAME);
        }
        return this.name;
    }

    public String getName() {
        return name;
    }

    public ContinuousNode setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    public Number getCount() {
        return count;
    }

    public ContinuousNode setCount(
        @org.jpmml.model.annotations.Property("count")
        Number count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ContinuousNode addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasDerivedFields() {
        return ((this.derivedFields!= null)&&(!this.derivedFields.isEmpty()));
    }

    public List<DerivedField> getDerivedFields() {
        if (derivedFields == null) {
            derivedFields = new ArrayList<DerivedField>();
        }
        return this.derivedFields;
    }

    public ContinuousNode addDerivedFields(DerivedField... derivedFields) {
        getDerivedFields().addAll(Arrays.asList(derivedFields));
        return this;
    }

    public boolean hasContent() {
        return ((this.content!= null)&&(!this.content.isEmpty()));
    }

    public List<org.dmg.pmml.PMMLObject> requireContent() {
        if ((this.content == null)||this.content.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.CONTINUOUSNODE_CONTENT);
        }
        return this.content;
    }

    public List<org.dmg.pmml.PMMLObject> getContent() {
        if (content == null) {
            content = new ArrayList<org.dmg.pmml.PMMLObject>();
        }
        return this.content;
    }

    public ContinuousNode addContent(org.dmg.pmml.PMMLObject... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasDerivedFields()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getDerivedFields());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
