
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PCovMatrix", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "pCovCells"
})
@JsonRootName("PCovMatrix")
@JsonPropertyOrder({
    "type",
    "extensions",
    "pCovCells"
})
public class PCovMatrix
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PCovMatrix>
{

    @XmlAttribute(name = "type")
    @Added((org.dmg.pmml.Version.PMML_3_2))
    @JsonProperty("type")
    private PCovMatrix.Type type;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "PCovCell", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("PCovCell")
    private List<PCovCell> pCovCells;
    private final static long serialVersionUID = 67371270L;

    public PCovMatrix() {
    }

    @ValueConstructor
    public PCovMatrix(
        @org.jpmml.model.annotations.Property("pCovCells")
        List<PCovCell> pCovCells) {
        this.pCovCells = pCovCells;
    }

    public PCovMatrix.Type getType() {
        return type;
    }

    public PCovMatrix setType(
        @org.jpmml.model.annotations.Property("type")
        PCovMatrix.Type type) {
        this.type = type;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PCovMatrix addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasPCovCells() {
        return ((this.pCovCells!= null)&&(!this.pCovCells.isEmpty()));
    }

    public List<PCovCell> requirePCovCells() {
        if ((this.pCovCells == null)||this.pCovCells.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.PCOVMATRIX_PCOVCELLS);
        }
        return this.pCovCells;
    }

    public List<PCovCell> getPCovCells() {
        if (pCovCells == null) {
            pCovCells = new ArrayList<PCovCell>();
        }
        return this.pCovCells;
    }

    public PCovMatrix addPCovCells(PCovCell... pCovCells) {
        getPCovCells().addAll(Arrays.asList(pCovCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasPCovCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getPCovCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<PCovMatrix.Type>
    {

        @XmlEnumValue("model")
        @JsonProperty("model")
        MODEL("model"),
        @XmlEnumValue("robust")
        @JsonProperty("robust")
        ROBUST("robust");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static PCovMatrix.Type fromValue(String v) {
            for (PCovMatrix.Type c: PCovMatrix.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
