
package org.dmg.pmml.sequence;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AntecedentSequence", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "sequenceReference",
    "time"
})
@JsonRootName("AntecedentSequence")
@JsonPropertyOrder({
    "extensions",
    "sequenceReference",
    "time"
})
public class AntecedentSequence
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<AntecedentSequence>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "SequenceReference", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("SequenceReference")
    private SequenceReference sequenceReference;
    @XmlElement(name = "Time", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Time")
    private Time time;
    private final static long serialVersionUID = 67371270L;

    public AntecedentSequence() {
    }

    @ValueConstructor
    public AntecedentSequence(
        @org.jpmml.model.annotations.Property("sequenceReference")
        SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public AntecedentSequence addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public SequenceReference requireSequenceReference() {
        if (this.sequenceReference == null) {
            throw new MissingElementException(this, PMMLElements.ANTECEDENTSEQUENCE_SEQUENCEREFERENCE);
        }
        return this.sequenceReference;
    }

    public SequenceReference getSequenceReference() {
        return sequenceReference;
    }

    public AntecedentSequence setSequenceReference(
        @org.jpmml.model.annotations.Property("sequenceReference")
        SequenceReference sequenceReference) {
        this.sequenceReference = sequenceReference;
        return this;
    }

    public Time getTime() {
        return time;
    }

    public AntecedentSequence setTime(
        @org.jpmml.model.annotations.Property("time")
        Time time) {
        this.time = time;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSequenceReference(), getTime());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
