
package org.dmg.pmml.time_series;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ThetaRecursionState", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "finalNoise",
    "finalPredictedNoise",
    "finalTheta",
    "finalNu"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
@JsonRootName("ThetaRecursionState")
@JsonPropertyOrder({
    "finalNoise",
    "finalPredictedNoise",
    "finalTheta",
    "finalNu"
})
public class ThetaRecursionState
    extends org.dmg.pmml.PMMLObject
{

    @XmlElement(name = "FinalNoise", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FinalNoise")
    private FinalNoise finalNoise;
    @XmlElement(name = "FinalPredictedNoise", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FinalPredictedNoise")
    private FinalPredictedNoise finalPredictedNoise;
    @XmlElement(name = "FinalTheta", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FinalTheta")
    private FinalTheta finalTheta;
    @XmlElement(name = "FinalNu", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FinalNu")
    private FinalNu finalNu;
    private final static long serialVersionUID = 67371270L;

    public ThetaRecursionState() {
    }

    @ValueConstructor
    public ThetaRecursionState(
        @org.jpmml.model.annotations.Property("finalNoise")
        FinalNoise finalNoise,
        @org.jpmml.model.annotations.Property("finalPredictedNoise")
        FinalPredictedNoise finalPredictedNoise,
        @org.jpmml.model.annotations.Property("finalTheta")
        FinalTheta finalTheta,
        @org.jpmml.model.annotations.Property("finalNu")
        FinalNu finalNu) {
        this.finalNoise = finalNoise;
        this.finalPredictedNoise = finalPredictedNoise;
        this.finalTheta = finalTheta;
        this.finalNu = finalNu;
    }

    public FinalNoise requireFinalNoise() {
        if (this.finalNoise == null) {
            throw new MissingElementException(this, PMMLElements.THETARECURSIONSTATE_FINALNOISE);
        }
        return this.finalNoise;
    }

    public FinalNoise getFinalNoise() {
        return finalNoise;
    }

    public ThetaRecursionState setFinalNoise(
        @org.jpmml.model.annotations.Property("finalNoise")
        FinalNoise finalNoise) {
        this.finalNoise = finalNoise;
        return this;
    }

    public FinalPredictedNoise requireFinalPredictedNoise() {
        if (this.finalPredictedNoise == null) {
            throw new MissingElementException(this, PMMLElements.THETARECURSIONSTATE_FINALPREDICTEDNOISE);
        }
        return this.finalPredictedNoise;
    }

    public FinalPredictedNoise getFinalPredictedNoise() {
        return finalPredictedNoise;
    }

    public ThetaRecursionState setFinalPredictedNoise(
        @org.jpmml.model.annotations.Property("finalPredictedNoise")
        FinalPredictedNoise finalPredictedNoise) {
        this.finalPredictedNoise = finalPredictedNoise;
        return this;
    }

    public FinalTheta requireFinalTheta() {
        if (this.finalTheta == null) {
            throw new MissingElementException(this, PMMLElements.THETARECURSIONSTATE_FINALTHETA);
        }
        return this.finalTheta;
    }

    public FinalTheta getFinalTheta() {
        return finalTheta;
    }

    public ThetaRecursionState setFinalTheta(
        @org.jpmml.model.annotations.Property("finalTheta")
        FinalTheta finalTheta) {
        this.finalTheta = finalTheta;
        return this;
    }

    public FinalNu requireFinalNu() {
        if (this.finalNu == null) {
            throw new MissingElementException(this, PMMLElements.THETARECURSIONSTATE_FINALNU);
        }
        return this.finalNu;
    }

    public FinalNu getFinalNu() {
        return finalNu;
    }

    public ThetaRecursionState setFinalNu(
        @org.jpmml.model.annotations.Property("finalNu")
        FinalNu finalNu) {
        this.finalNu = finalNu;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFinalNoise(), getFinalPredictedNoise(), getFinalTheta(), getFinalNu());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
