
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Anova", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "anovaRows"
})
@JsonRootName("Anova")
@JsonPropertyOrder({
    "targetField",
    "extensions",
    "anovaRows"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class Anova
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Anova>
{

    @XmlAttribute(name = "target")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("target")
    private String targetField;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "AnovaRow", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("AnovaRow")
    private List<AnovaRow> anovaRows;
    private final static long serialVersionUID = 67371270L;

    public Anova() {
    }

    @ValueConstructor
    public Anova(
        @org.jpmml.model.annotations.Property("anovaRows")
        List<AnovaRow> anovaRows) {
        this.anovaRows = anovaRows;
    }

    public String getTargetField() {
        return targetField;
    }

    public Anova setTargetField(
        @org.jpmml.model.annotations.Property("targetField")
        String targetField) {
        this.targetField = targetField;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Anova addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasAnovaRows() {
        return ((this.anovaRows!= null)&&(!this.anovaRows.isEmpty()));
    }

    public List<AnovaRow> requireAnovaRows() {
        if ((this.anovaRows == null)||this.anovaRows.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.ANOVA_ANOVAROWS);
        }
        return this.anovaRows;
    }

    public List<AnovaRow> getAnovaRows() {
        if (anovaRows == null) {
            anovaRows = new ArrayList<AnovaRow>();
        }
        return this.anovaRows;
    }

    public Anova addAnovaRows(AnovaRow... anovaRows) {
        getAnovaRows().addAll(Arrays.asList(anovaRows));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasAnovaRows()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getAnovaRows());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
