
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;

@XmlRootElement(name = "Numerator", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "nonseasonalFactor",
    "seasonalFactor"
})
@JsonRootName("Numerator")
@JsonPropertyOrder({
    "extensions",
    "nonseasonalFactor",
    "seasonalFactor"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class Numerator
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Numerator>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "NonseasonalFactor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("NonseasonalFactor")
    private NonseasonalFactor nonseasonalFactor;
    @XmlElement(name = "SeasonalFactor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("SeasonalFactor")
    private SeasonalFactor seasonalFactor;
    private final static long serialVersionUID = 67371270L;

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Numerator addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public NonseasonalFactor getNonseasonalFactor() {
        return nonseasonalFactor;
    }

    public Numerator setNonseasonalFactor(
        @Property("nonseasonalFactor")
        NonseasonalFactor nonseasonalFactor) {
        this.nonseasonalFactor = nonseasonalFactor;
        return this;
    }

    public SeasonalFactor getSeasonalFactor() {
        return seasonalFactor;
    }

    public Numerator setSeasonalFactor(
        @Property("seasonalFactor")
        SeasonalFactor seasonalFactor) {
        this.seasonalFactor = seasonalFactor;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getNonseasonalFactor(), getSeasonalFactor());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
