
package org.dmg.pmml.regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasName;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PredictorTerm", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "fieldRefs"
})
@JsonRootName("PredictorTerm")
@JsonPropertyOrder({
    "name",
    "coefficient",
    "extensions",
    "fieldRefs"
})
public class PredictorTerm
    extends Term
    implements HasExtensions<PredictorTerm> , HasName<PredictorTerm>
{

    @XmlAttribute(name = "name")
    @JsonProperty("name")
    @Added((org.dmg.pmml.Version.PMML_4_1))
    private String name;
    @XmlAttribute(name = "coefficient", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("coefficient")
    private Number coefficient;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("FieldRef")
    private List<FieldRef> fieldRefs;
    private final static long serialVersionUID = 67371270L;

    public PredictorTerm() {
    }

    @ValueConstructor
    public PredictorTerm(
        @org.jpmml.model.annotations.Property("coefficient")
        Number coefficient,
        @org.jpmml.model.annotations.Property("fieldRefs")
        List<FieldRef> fieldRefs) {
        this.coefficient = coefficient;
        this.fieldRefs = fieldRefs;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public PredictorTerm setName(
        @org.jpmml.model.annotations.Property("name")
        String name) {
        this.name = name;
        return this;
    }

    @Override
    public Number requireCoefficient() {
        if (this.coefficient == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PREDICTORTERM_COEFFICIENT);
        }
        return this.coefficient;
    }

    @Override
    public Number getCoefficient() {
        return coefficient;
    }

    @Override
    public PredictorTerm setCoefficient(
        @org.jpmml.model.annotations.Property("coefficient")
        Number coefficient) {
        this.coefficient = coefficient;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PredictorTerm addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasFieldRefs() {
        return ((this.fieldRefs!= null)&&(!this.fieldRefs.isEmpty()));
    }

    public List<FieldRef> requireFieldRefs() {
        if ((this.fieldRefs == null)||this.fieldRefs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.PREDICTORTERM_FIELDREFS);
        }
        return this.fieldRefs;
    }

    public List<FieldRef> getFieldRefs() {
        if (fieldRefs == null) {
            fieldRefs = new ArrayList<FieldRef>();
        }
        return this.fieldRefs;
    }

    public PredictorTerm addFieldRefs(FieldRef... fieldRefs) {
        getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldRefs()) {
                status = PMMLObject.traverse(visitor, getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
