
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ModelVerification", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "verificationFields",
    "inlineTable"
})
@JsonRootName("ModelVerification")
@JsonPropertyOrder({
    "recordCount",
    "fieldCount",
    "extensions",
    "verificationFields",
    "inlineTable"
})
public class ModelVerification
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ModelVerification>
{

    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("recordCount")
    private Integer recordCount;
    @XmlAttribute(name = "fieldCount")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("fieldCount")
    private Integer fieldCount;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "VerificationFields", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("VerificationFields")
    private VerificationFields verificationFields;
    @XmlElement(name = "InlineTable", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("InlineTable")
    private InlineTable inlineTable;
    private final static long serialVersionUID = 67371271L;

    public ModelVerification() {
    }

    @ValueConstructor
    public ModelVerification(
        @org.jpmml.model.annotations.Property("verificationFields")
        VerificationFields verificationFields,
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.verificationFields = verificationFields;
        this.inlineTable = inlineTable;
    }

    public Integer getRecordCount() {
        return recordCount;
    }

    public ModelVerification setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Integer recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    public Integer getFieldCount() {
        return fieldCount;
    }

    public ModelVerification setFieldCount(
        @org.jpmml.model.annotations.Property("fieldCount")
        Integer fieldCount) {
        this.fieldCount = fieldCount;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public ModelVerification addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public VerificationFields requireVerificationFields() {
        if (this.verificationFields == null) {
            throw new MissingElementException(this, PMMLElements.MODELVERIFICATION_VERIFICATIONFIELDS);
        }
        return this.verificationFields;
    }

    public VerificationFields getVerificationFields() {
        return verificationFields;
    }

    public ModelVerification setVerificationFields(
        @org.jpmml.model.annotations.Property("verificationFields")
        VerificationFields verificationFields) {
        this.verificationFields = verificationFields;
        return this;
    }

    public InlineTable requireInlineTable() {
        if (this.inlineTable == null) {
            throw new MissingElementException(this, PMMLElements.MODELVERIFICATION_INLINETABLE);
        }
        return this.inlineTable;
    }

    public InlineTable getInlineTable() {
        return inlineTable;
    }

    public ModelVerification setInlineTable(
        @org.jpmml.model.annotations.Property("inlineTable")
        InlineTable inlineTable) {
        this.inlineTable = inlineTable;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getVerificationFields(), getInlineTable());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
