
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PartitionFieldStats", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "counts",
    "numericInfo",
    "arrays"
})
@JsonRootName("PartitionFieldStats")
@JsonPropertyOrder({
    "field",
    "weighted",
    "extensions",
    "counts",
    "numericInfo",
    "arrays"
})
public class PartitionFieldStats
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<PartitionFieldStats> , HasFieldReference<PartitionFieldStats>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "weighted")
    @JsonProperty("weighted")
    @Added((org.dmg.pmml.Version.PMML_4_0))
    private PartitionFieldStats.Weighted weighted;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Counts", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Counts")
    private Counts counts;
    @XmlElement(name = "NumericInfo", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("NumericInfo")
    private NumericInfo numericInfo;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private List<Array> arrays;
    private final static long serialVersionUID = 67371271L;

    public PartitionFieldStats() {
    }

    @ValueConstructor
    public PartitionFieldStats(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public PartitionFieldStats(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PARTITIONFIELDSTATS_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public PartitionFieldStats setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public PartitionFieldStats.Weighted getWeighted() {
        if (weighted == null) {
            return PartitionFieldStats.Weighted.ZERO;
        } else {
            return weighted;
        }
    }

    public PartitionFieldStats setWeighted(
        @org.jpmml.model.annotations.Property("weighted")
        PartitionFieldStats.Weighted weighted) {
        this.weighted = weighted;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public PartitionFieldStats addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Counts getCounts() {
        return counts;
    }

    public PartitionFieldStats setCounts(
        @org.jpmml.model.annotations.Property("counts")
        Counts counts) {
        this.counts = counts;
        return this;
    }

    public NumericInfo getNumericInfo() {
        return numericInfo;
    }

    public PartitionFieldStats setNumericInfo(
        @org.jpmml.model.annotations.Property("numericInfo")
        NumericInfo numericInfo) {
        this.numericInfo = numericInfo;
        return this;
    }

    public boolean hasArrays() {
        return ((this.arrays!= null)&&(!this.arrays.isEmpty()));
    }

    public List<Array> getArrays() {
        if (arrays == null) {
            arrays = new ArrayList<Array>();
        }
        return this.arrays;
    }

    public PartitionFieldStats addArrays(Array... arrays) {
        getArrays().addAll(Arrays.asList(arrays));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getCounts(), getNumericInfo());
            }
            if ((status == VisitorAction.CONTINUE)&&hasArrays()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArrays());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Weighted
        implements StringValue<PartitionFieldStats.Weighted>
    {

        @XmlEnumValue("0")
        @JsonProperty("0")
        ZERO("0"),
        @XmlEnumValue("1")
        @JsonProperty("1")
        ONE("1");
        private final String value;

        Weighted(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static PartitionFieldStats.Weighted fromValue(String v) {
            for (PartitionFieldStats.Weighted c: PartitionFieldStats.Weighted.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
