
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Array;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SeasonalFactor", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "array"
})
@JsonRootName("SeasonalFactor")
@JsonPropertyOrder({
    "difference",
    "maximumOrder",
    "extensions",
    "array"
})
@Added((org.dmg.pmml.Version.PMML_4_4))
public class SeasonalFactor
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<SeasonalFactor>
{

    @XmlAttribute(name = "difference")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("difference")
    private Integer difference;
    @XmlAttribute(name = "maximumOrder")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("maximumOrder")
    private Integer maximumOrder;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    private List<Extension> extensions;
    @XmlElement(name = "Array", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Array")
    private Array array;
    private final static Integer DEFAULT_DIFFERENCE = new IntegerAdapter().unmarshal("0");
    private final static long serialVersionUID = 67371271L;

    public SeasonalFactor() {
    }

    @ValueConstructor
    public SeasonalFactor(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
    }

    public Integer getDifference() {
        if (difference == null) {
            return DEFAULT_DIFFERENCE;
        } else {
            return difference;
        }
    }

    public SeasonalFactor setDifference(
        @org.jpmml.model.annotations.Property("difference")
        Integer difference) {
        this.difference = difference;
        return this;
    }

    public Integer getMaximumOrder() {
        return maximumOrder;
    }

    public SeasonalFactor setMaximumOrder(
        @org.jpmml.model.annotations.Property("maximumOrder")
        Integer maximumOrder) {
        this.maximumOrder = maximumOrder;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SeasonalFactor addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.SEASONALFACTOR_ARRAY);
        }
        return this.array;
    }

    public Array getArray() {
        return array;
    }

    public SeasonalFactor setArray(
        @org.jpmml.model.annotations.Property("array")
        Array array) {
        this.array = array;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getArray());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
