/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLAttributes;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="GaussianDistribution", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions"})
@JsonRootName(value="GaussianDistribution")
@JsonPropertyOrder(value={"mean", "variance", "extensions"})
@Added(value=Version.PMML_4_1)
public class GaussianDistribution
extends ContinuousDistribution
implements HasExtensions<GaussianDistribution> {
    @XmlAttribute(name="mean", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="mean")
    private Number mean;
    @XmlAttribute(name="variance", required=true)
    @XmlJavaTypeAdapter(value=RealNumberAdapter.class)
    @JsonProperty(value="variance")
    private Number variance;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371271L;

    public GaussianDistribution() {
    }

    @ValueConstructor
    public GaussianDistribution(@Property(value="mean") Number mean, @Property(value="variance") Number variance) {
        this.mean = mean;
        this.variance = variance;
    }

    public Number requireMean() {
        if (this.mean == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GAUSSIANDISTRIBUTION_MEAN);
        }
        return this.mean;
    }

    public Number getMean() {
        return this.mean;
    }

    public GaussianDistribution setMean(@Property(value="mean") Number mean) {
        this.mean = mean;
        return this;
    }

    public Number requireVariance() {
        if (this.variance == null) {
            throw new MissingAttributeException(this, PMMLAttributes.GAUSSIANDISTRIBUTION_VARIANCE);
        }
        return this.variance;
    }

    public Number getVariance() {
        return this.variance;
    }

    public GaussianDistribution setVariance(@Property(value="variance") Number variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public GaussianDistribution addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

