
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;

@XmlRootElement(name = "Annotation", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "content"
})
@JsonRootName("Annotation")
@JsonPropertyOrder({
    "content"
})
public class Annotation
    extends org.dmg.pmml.PMMLObject
    implements HasMixedContent<Annotation>
{

    @XmlElementRef(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4", type = Extension.class, required = false)
    @XmlMixed
    @XmlAnyElement(lax = true)
    @JsonProperty("content")
    private List<Object> content;
    private static final long serialVersionUID = 67371272L;

    @Override
    public boolean hasContent() {
        return ((this.content!= null)&&(!this.content.isEmpty()));
    }

    @Override
    public List<Object> getContent() {
        if (content == null) {
            content = new ArrayList<>();
        }
        return this.content;
    }

    @Override
    public Annotation addContent(Object... content) {
        getContent().addAll(Arrays.asList(content));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasContent()) {
                status = org.dmg.pmml.PMMLObject.traverseMixed(visitor, getContent());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
