
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.PositiveIntegerAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Lag", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "blockIndicators"
})
@JsonRootName("Lag")
@JsonPropertyOrder({
    "field",
    "n",
    "aggregate",
    "extensions",
    "blockIndicators"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_3))
public class Lag
    extends Expression
    implements HasExtensions<Lag> , HasFieldReference<Lag>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "n")
    @XmlJavaTypeAdapter(PositiveIntegerAdapter.class)
    @XmlSchemaType(name = "positiveInteger")
    @JsonProperty("n")
    private Integer n;
    @XmlAttribute(name = "aggregate")
    @JsonProperty("aggregate")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private Lag.Aggregate aggregate;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "BlockIndicator", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("BlockIndicator")
    @CollectionElementType(BlockIndicator.class)
    private List<BlockIndicator> blockIndicators;
    private static final Integer DEFAULT_N = new PositiveIntegerAdapter().unmarshal("1");
    private static final long serialVersionUID = 67371272L;

    public Lag() {
    }

    @ValueConstructor
    public Lag(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
    }

    @AlternateValueConstructor
    public Lag(Field<?> field) {
        this(((field!= null)?field.requireName():null));
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.LAG_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public Lag setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public Integer getN() {
        if (n == null) {
            return DEFAULT_N;
        } else {
            return n;
        }
    }

    public Lag setN(
        @org.jpmml.model.annotations.Property("n")
        Integer n) {
        this.n = n;
        return this;
    }

    public Lag.Aggregate getAggregate() {
        if (aggregate == null) {
            return Lag.Aggregate.NONE;
        } else {
            return aggregate;
        }
    }

    public Lag setAggregate(
        @org.jpmml.model.annotations.Property("aggregate")
        Lag.Aggregate aggregate) {
        this.aggregate = aggregate;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Lag addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBlockIndicators() {
        return ((this.blockIndicators!= null)&&(!this.blockIndicators.isEmpty()));
    }

    public List<BlockIndicator> getBlockIndicators() {
        if (blockIndicators == null) {
            blockIndicators = new ArrayList<>();
        }
        return this.blockIndicators;
    }

    public Lag addBlockIndicators(BlockIndicator... blockIndicators) {
        getBlockIndicators().addAll(Arrays.asList(blockIndicators));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBlockIndicators()) {
                status = PMMLObject.traverse(visitor, getBlockIndicators());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Aggregate
        implements StringValue<Lag.Aggregate>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("avg")
        @JsonProperty("avg")
        AVG("avg"),
        @XmlEnumValue("max")
        @JsonProperty("max")
        MAX("max"),
        @XmlEnumValue("median")
        @JsonProperty("median")
        MEDIAN("median"),
        @XmlEnumValue("min")
        @JsonProperty("min")
        MIN("min"),
        @XmlEnumValue("product")
        @JsonProperty("product")
        PRODUCT("product"),
        @XmlEnumValue("sum")
        @JsonProperty("sum")
        SUM("sum"),
        @XmlEnumValue("stddev")
        @JsonProperty("stddev")
        STDDEV("stddev");
        private final String value;

        Aggregate(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Lag.Aggregate fromValue(String v) {
            for (Lag.Aggregate c: Lag.Aggregate.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
