
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "LiftData", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "modelLiftGraph",
    "optimumLiftGraph",
    "randomLiftGraph"
})
@JsonRootName("LiftData")
@JsonPropertyOrder({
    "targetFieldValue",
    "targetFieldDisplayValue",
    "rankingQuality",
    "extensions",
    "modelLiftGraph",
    "optimumLiftGraph",
    "randomLiftGraph"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class LiftData
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<LiftData>
{

    @XmlAttribute(name = "targetFieldValue")
    @JsonProperty("targetFieldValue")
    private String targetFieldValue;
    @XmlAttribute(name = "targetFieldDisplayValue")
    @JsonProperty("targetFieldDisplayValue")
    private String targetFieldDisplayValue;
    @XmlAttribute(name = "rankingQuality")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("rankingQuality")
    private Number rankingQuality;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "ModelLiftGraph", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ModelLiftGraph")
    private ModelLiftGraph modelLiftGraph;
    @XmlElement(name = "OptimumLiftGraph", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("OptimumLiftGraph")
    private OptimumLiftGraph optimumLiftGraph;
    @XmlElement(name = "RandomLiftGraph", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("RandomLiftGraph")
    private RandomLiftGraph randomLiftGraph;
    private static final long serialVersionUID = 67371272L;

    public LiftData() {
    }

    @ValueConstructor
    public LiftData(
        @org.jpmml.model.annotations.Property("modelLiftGraph")
        ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
    }

    public String getTargetFieldValue() {
        return targetFieldValue;
    }

    public LiftData setTargetFieldValue(
        @org.jpmml.model.annotations.Property("targetFieldValue")
        String targetFieldValue) {
        this.targetFieldValue = targetFieldValue;
        return this;
    }

    public String getTargetFieldDisplayValue() {
        return targetFieldDisplayValue;
    }

    public LiftData setTargetFieldDisplayValue(
        @org.jpmml.model.annotations.Property("targetFieldDisplayValue")
        String targetFieldDisplayValue) {
        this.targetFieldDisplayValue = targetFieldDisplayValue;
        return this;
    }

    public Number getRankingQuality() {
        return rankingQuality;
    }

    public LiftData setRankingQuality(
        @org.jpmml.model.annotations.Property("rankingQuality")
        Number rankingQuality) {
        this.rankingQuality = rankingQuality;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public LiftData addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public ModelLiftGraph requireModelLiftGraph() {
        if (this.modelLiftGraph == null) {
            throw new MissingElementException(this, PMMLElements.LIFTDATA_MODELLIFTGRAPH);
        }
        return this.modelLiftGraph;
    }

    public ModelLiftGraph getModelLiftGraph() {
        return modelLiftGraph;
    }

    public LiftData setModelLiftGraph(
        @org.jpmml.model.annotations.Property("modelLiftGraph")
        ModelLiftGraph modelLiftGraph) {
        this.modelLiftGraph = modelLiftGraph;
        return this;
    }

    public OptimumLiftGraph getOptimumLiftGraph() {
        return optimumLiftGraph;
    }

    public LiftData setOptimumLiftGraph(
        @org.jpmml.model.annotations.Property("optimumLiftGraph")
        OptimumLiftGraph optimumLiftGraph) {
        this.optimumLiftGraph = optimumLiftGraph;
        return this;
    }

    public RandomLiftGraph getRandomLiftGraph() {
        return randomLiftGraph;
    }

    public LiftData setRandomLiftGraph(
        @org.jpmml.model.annotations.Property("randomLiftGraph")
        RandomLiftGraph randomLiftGraph) {
        this.randomLiftGraph = randomLiftGraph;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getModelLiftGraph(), getOptimumLiftGraph(), getRandomLiftGraph());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
