
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "minkowski", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("minkowski")
@JsonPropertyOrder({
    "pParameter",
    "extensions"
})
public class Minkowski
    extends Distance
    implements HasExtensions<Minkowski>
{

    @XmlAttribute(name = "p-parameter", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("p-parameter")
    private Number pParameter;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public Minkowski() {
    }

    @ValueConstructor
    public Minkowski(
        @org.jpmml.model.annotations.Property("pParameter")
        Number pParameter) {
        this.pParameter = pParameter;
    }

    public Number requirePParameter() {
        if (this.pParameter == null) {
            throw new MissingAttributeException(this, PMMLAttributes.MINKOWSKI_PPARAMETER);
        }
        return this.pParameter;
    }

    public Number getPParameter() {
        return pParameter;
    }

    public Minkowski setPParameter(
        @org.jpmml.model.annotations.Property("pParameter")
        Number pParameter) {
        this.pParameter = pParameter;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Minkowski addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
