
package org.dmg.pmml;

import java.util.List;
import javax.xml.namespace.QName;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlRegistry;
import org.dmg.pmml.baseline.CountTable;


/**
 * This object contains factory methods for each 
 * Java content interface and Java element interface 
 * generated in the org.dmg.pmml package. 
 * <p>An ObjectFactory allows you to programmatically 
 * construct new instances of the Java representation 
 * for XML content. The Java representation of XML 
 * content can consist of schema derived interfaces 
 * and classes representing the binding of schema 
 * type definitions, element declarations and model 
 * groups.  Factory methods for each of these are 
 * provided in this class.
 * 
 */
@XmlRegistry
public class ObjectFactory {

    private static final QName _CountTable_QNAME = new QName("http://www.dmg.org/PMML-4_4", "CountTable");
    private static final QName _NormalizedCountTable_QNAME = new QName("http://www.dmg.org/PMML-4_4", "NormalizedCountTable");
    private static final QName _Indices_QNAME = new QName("http://www.dmg.org/PMML-4_4", "Indices");
    private static final QName _INTEntries_QNAME = new QName("http://www.dmg.org/PMML-4_4", "INT-Entries");
    private static final QName _REALEntries_QNAME = new QName("http://www.dmg.org/PMML-4_4", "REAL-Entries");

    /**
     * Create a new ObjectFactory that can be used to create new instances of schema derived classes for package: org.dmg.pmml
     * 
     */
    public ObjectFactory() {
    }

    /**
     * Create an instance of {@link NormDiscrete }
     * 
     * @return
     *     the new instance of {@link NormDiscrete }
     */
    public NormDiscrete createNormDiscrete() {
        return new NormDiscrete();
    }

    /**
     * Create an instance of {@link Interval }
     * 
     * @return
     *     the new instance of {@link Interval }
     */
    public Interval createInterval() {
        return new Interval();
    }

    /**
     * Create an instance of {@link Aggregate }
     * 
     * @return
     *     the new instance of {@link Aggregate }
     */
    public Aggregate createAggregate() {
        return new Aggregate();
    }

    /**
     * Create an instance of {@link Lag }
     * 
     * @return
     *     the new instance of {@link Lag }
     */
    public Lag createLag() {
        return new Lag();
    }

    /**
     * Create an instance of {@link TextIndex }
     * 
     * @return
     *     the new instance of {@link TextIndex }
     */
    public TextIndex createTextIndex() {
        return new TextIndex();
    }

    /**
     * Create an instance of {@link MiningField }
     * 
     * @return
     *     the new instance of {@link MiningField }
     */
    public MiningField createMiningField() {
        return new MiningField();
    }

    /**
     * Create an instance of {@link Value }
     * 
     * @return
     *     the new instance of {@link Value }
     */
    public Value createValue() {
        return new Value();
    }

    /**
     * Create an instance of {@link OutputField }
     * 
     * @return
     *     the new instance of {@link OutputField }
     */
    public OutputField createOutputField() {
        return new OutputField();
    }

    /**
     * Create an instance of {@link Array }
     * 
     * @return
     *     the new instance of {@link Array }
     */
    public Array createArray() {
        return new Array();
    }

    /**
     * Create an instance of {@link AnovaRow }
     * 
     * @return
     *     the new instance of {@link AnovaRow }
     */
    public AnovaRow createAnovaRow() {
        return new AnovaRow();
    }

    /**
     * Create an instance of {@link UnivariateStats }
     * 
     * @return
     *     the new instance of {@link UnivariateStats }
     */
    public UnivariateStats createUnivariateStats() {
        return new UnivariateStats();
    }

    /**
     * Create an instance of {@link Matrix }
     * 
     * @return
     *     the new instance of {@link Matrix }
     */
    public Matrix createMatrix() {
        return new Matrix();
    }

    /**
     * Create an instance of {@link PredictiveModelQuality }
     * 
     * @return
     *     the new instance of {@link PredictiveModelQuality }
     */
    public PredictiveModelQuality createPredictiveModelQuality() {
        return new PredictiveModelQuality();
    }

    /**
     * Create an instance of {@link PartitionFieldStats }
     * 
     * @return
     *     the new instance of {@link PartitionFieldStats }
     */
    public PartitionFieldStats createPartitionFieldStats() {
        return new PartitionFieldStats();
    }

    /**
     * Create an instance of {@link Target }
     * 
     * @return
     *     the new instance of {@link Target }
     */
    public Target createTarget() {
        return new Target();
    }

    /**
     * Create an instance of {@link SimplePredicate }
     * 
     * @return
     *     the new instance of {@link SimplePredicate }
     */
    public SimplePredicate createSimplePredicate() {
        return new SimplePredicate();
    }

    /**
     * Create an instance of {@link SimpleSetPredicate }
     * 
     * @return
     *     the new instance of {@link SimpleSetPredicate }
     */
    public SimpleSetPredicate createSimpleSetPredicate() {
        return new SimpleSetPredicate();
    }

    /**
     * Create an instance of {@link CompoundPredicate }
     * 
     * @return
     *     the new instance of {@link CompoundPredicate }
     */
    public CompoundPredicate createCompoundPredicate() {
        return new CompoundPredicate();
    }

    /**
     * Create an instance of {@link ComparisonMeasure }
     * 
     * @return
     *     the new instance of {@link ComparisonMeasure }
     */
    public ComparisonMeasure createComparisonMeasure() {
        return new ComparisonMeasure();
    }

    /**
     * Create an instance of {@link ChildParent }
     * 
     * @return
     *     the new instance of {@link ChildParent }
     */
    public ChildParent createChildParent() {
        return new ChildParent();
    }

    /**
     * Create an instance of {@link DataField }
     * 
     * @return
     *     the new instance of {@link DataField }
     */
    public DataField createDataField() {
        return new DataField();
    }

    /**
     * Create an instance of {@link DefineFunction }
     * 
     * @return
     *     the new instance of {@link DefineFunction }
     */
    public DefineFunction createDefineFunction() {
        return new DefineFunction();
    }

    /**
     * Create an instance of {@link Extension }
     * 
     * @return
     *     the new instance of {@link Extension }
     */
    public Extension createExtension() {
        return new Extension();
    }

    /**
     * Create an instance of {@link ParameterField }
     * 
     * @return
     *     the new instance of {@link ParameterField }
     */
    public ParameterField createParameterField() {
        return new ParameterField();
    }

    /**
     * Create an instance of {@link Constant }
     * 
     * @return
     *     the new instance of {@link Constant }
     */
    public Constant createConstant() {
        return new Constant();
    }

    /**
     * Create an instance of {@link FieldRef }
     * 
     * @return
     *     the new instance of {@link FieldRef }
     */
    public FieldRef createFieldRef() {
        return new FieldRef();
    }

    /**
     * Create an instance of {@link NormContinuous }
     * 
     * @return
     *     the new instance of {@link NormContinuous }
     */
    public NormContinuous createNormContinuous() {
        return new NormContinuous();
    }

    /**
     * Create an instance of {@link LinearNorm }
     * 
     * @return
     *     the new instance of {@link LinearNorm }
     */
    public LinearNorm createLinearNorm() {
        return new LinearNorm();
    }

    /**
     * Create an instance of {@link Discretize }
     * 
     * @return
     *     the new instance of {@link Discretize }
     */
    public Discretize createDiscretize() {
        return new Discretize();
    }

    /**
     * Create an instance of {@link DiscretizeBin }
     * 
     * @return
     *     the new instance of {@link DiscretizeBin }
     */
    public DiscretizeBin createDiscretizeBin() {
        return new DiscretizeBin();
    }

    /**
     * Create an instance of {@link MapValues }
     * 
     * @return
     *     the new instance of {@link MapValues }
     */
    public MapValues createMapValues() {
        return new MapValues();
    }

    /**
     * Create an instance of {@link FieldColumnPair }
     * 
     * @return
     *     the new instance of {@link FieldColumnPair }
     */
    public FieldColumnPair createFieldColumnPair() {
        return new FieldColumnPair();
    }

    /**
     * Create an instance of {@link TableLocator }
     * 
     * @return
     *     the new instance of {@link TableLocator }
     */
    public TableLocator createTableLocator() {
        return new TableLocator();
    }

    /**
     * Create an instance of {@link InlineTable }
     * 
     * @return
     *     the new instance of {@link InlineTable }
     */
    public InlineTable createInlineTable() {
        return new InlineTable();
    }

    /**
     * Create an instance of {@link Row }
     * 
     * @return
     *     the new instance of {@link Row }
     */
    public Row createRow() {
        return new Row();
    }

    /**
     * Create an instance of {@link TextIndexNormalization }
     * 
     * @return
     *     the new instance of {@link TextIndexNormalization }
     */
    public TextIndexNormalization createTextIndexNormalization() {
        return new TextIndexNormalization();
    }

    /**
     * Create an instance of {@link Apply }
     * 
     * @return
     *     the new instance of {@link Apply }
     */
    public Apply createApply() {
        return new Apply();
    }

    /**
     * Create an instance of {@link BlockIndicator }
     * 
     * @return
     *     the new instance of {@link BlockIndicator }
     */
    public BlockIndicator createBlockIndicator() {
        return new BlockIndicator();
    }

    /**
     * Create an instance of {@link MiningSchema }
     * 
     * @return
     *     the new instance of {@link MiningSchema }
     */
    public MiningSchema createMiningSchema() {
        return new MiningSchema();
    }

    /**
     * Create an instance of {@link Output }
     * 
     * @return
     *     the new instance of {@link Output }
     */
    public Output createOutput() {
        return new Output();
    }

    /**
     * Create an instance of {@link Decisions }
     * 
     * @return
     *     the new instance of {@link Decisions }
     */
    public Decisions createDecisions() {
        return new Decisions();
    }

    /**
     * Create an instance of {@link Decision }
     * 
     * @return
     *     the new instance of {@link Decision }
     */
    public Decision createDecision() {
        return new Decision();
    }

    /**
     * Create an instance of {@link ModelStats }
     * 
     * @return
     *     the new instance of {@link ModelStats }
     */
    public ModelStats createModelStats() {
        return new ModelStats();
    }

    /**
     * Create an instance of {@link Counts }
     * 
     * @return
     *     the new instance of {@link Counts }
     */
    public Counts createCounts() {
        return new Counts();
    }

    /**
     * Create an instance of {@link NumericInfo }
     * 
     * @return
     *     the new instance of {@link NumericInfo }
     */
    public NumericInfo createNumericInfo() {
        return new NumericInfo();
    }

    /**
     * Create an instance of {@link Quantile }
     * 
     * @return
     *     the new instance of {@link Quantile }
     */
    public Quantile createQuantile() {
        return new Quantile();
    }

    /**
     * Create an instance of {@link DiscrStats }
     * 
     * @return
     *     the new instance of {@link DiscrStats }
     */
    public DiscrStats createDiscrStats() {
        return new DiscrStats();
    }

    /**
     * Create an instance of {@link ContStats }
     * 
     * @return
     *     the new instance of {@link ContStats }
     */
    public ContStats createContStats() {
        return new ContStats();
    }

    /**
     * Create an instance of {@link Anova }
     * 
     * @return
     *     the new instance of {@link Anova }
     */
    public Anova createAnova() {
        return new Anova();
    }

    /**
     * Create an instance of {@link MultivariateStats }
     * 
     * @return
     *     the new instance of {@link MultivariateStats }
     */
    public MultivariateStats createMultivariateStats() {
        return new MultivariateStats();
    }

    /**
     * Create an instance of {@link MultivariateStat }
     * 
     * @return
     *     the new instance of {@link MultivariateStat }
     */
    public MultivariateStat createMultivariateStat() {
        return new MultivariateStat();
    }

    /**
     * Create an instance of {@link ModelExplanation }
     * 
     * @return
     *     the new instance of {@link ModelExplanation }
     */
    public ModelExplanation createModelExplanation() {
        return new ModelExplanation();
    }

    /**
     * Create an instance of {@link ConfusionMatrix }
     * 
     * @return
     *     the new instance of {@link ConfusionMatrix }
     */
    public ConfusionMatrix createConfusionMatrix() {
        return new ConfusionMatrix();
    }

    /**
     * Create an instance of {@link ClassLabels }
     * 
     * @return
     *     the new instance of {@link ClassLabels }
     */
    public ClassLabels createClassLabels() {
        return new ClassLabels();
    }

    /**
     * Create an instance of {@link MatCell }
     * 
     * @return
     *     the new instance of {@link MatCell }
     */
    public MatCell createMatCell() {
        return new MatCell();
    }

    /**
     * Create an instance of {@link LiftData }
     * 
     * @return
     *     the new instance of {@link LiftData }
     */
    public LiftData createLiftData() {
        return new LiftData();
    }

    /**
     * Create an instance of {@link ModelLiftGraph }
     * 
     * @return
     *     the new instance of {@link ModelLiftGraph }
     */
    public ModelLiftGraph createModelLiftGraph() {
        return new ModelLiftGraph();
    }

    /**
     * Create an instance of {@link LiftGraph }
     * 
     * @return
     *     the new instance of {@link LiftGraph }
     */
    public LiftGraph createLiftGraph() {
        return new LiftGraph();
    }

    /**
     * Create an instance of {@link XCoordinates }
     * 
     * @return
     *     the new instance of {@link XCoordinates }
     */
    public XCoordinates createXCoordinates() {
        return new XCoordinates();
    }

    /**
     * Create an instance of {@link YCoordinates }
     * 
     * @return
     *     the new instance of {@link YCoordinates }
     */
    public YCoordinates createYCoordinates() {
        return new YCoordinates();
    }

    /**
     * Create an instance of {@link BoundaryValues }
     * 
     * @return
     *     the new instance of {@link BoundaryValues }
     */
    public BoundaryValues createBoundaryValues() {
        return new BoundaryValues();
    }

    /**
     * Create an instance of {@link BoundaryValueMeans }
     * 
     * @return
     *     the new instance of {@link BoundaryValueMeans }
     */
    public BoundaryValueMeans createBoundaryValueMeans() {
        return new BoundaryValueMeans();
    }

    /**
     * Create an instance of {@link OptimumLiftGraph }
     * 
     * @return
     *     the new instance of {@link OptimumLiftGraph }
     */
    public OptimumLiftGraph createOptimumLiftGraph() {
        return new OptimumLiftGraph();
    }

    /**
     * Create an instance of {@link RandomLiftGraph }
     * 
     * @return
     *     the new instance of {@link RandomLiftGraph }
     */
    public RandomLiftGraph createRandomLiftGraph() {
        return new RandomLiftGraph();
    }

    /**
     * Create an instance of {@link ROC }
     * 
     * @return
     *     the new instance of {@link ROC }
     */
    public ROC createROC() {
        return new ROC();
    }

    /**
     * Create an instance of {@link ROCGraph }
     * 
     * @return
     *     the new instance of {@link ROCGraph }
     */
    public ROCGraph createROCGraph() {
        return new ROCGraph();
    }

    /**
     * Create an instance of {@link ClusteringModelQuality }
     * 
     * @return
     *     the new instance of {@link ClusteringModelQuality }
     */
    public ClusteringModelQuality createClusteringModelQuality() {
        return new ClusteringModelQuality();
    }

    /**
     * Create an instance of {@link Correlations }
     * 
     * @return
     *     the new instance of {@link Correlations }
     */
    public Correlations createCorrelations() {
        return new Correlations();
    }

    /**
     * Create an instance of {@link CorrelationFields }
     * 
     * @return
     *     the new instance of {@link CorrelationFields }
     */
    public CorrelationFields createCorrelationFields() {
        return new CorrelationFields();
    }

    /**
     * Create an instance of {@link CorrelationValues }
     * 
     * @return
     *     the new instance of {@link CorrelationValues }
     */
    public CorrelationValues createCorrelationValues() {
        return new CorrelationValues();
    }

    /**
     * Create an instance of {@link CorrelationMethods }
     * 
     * @return
     *     the new instance of {@link CorrelationMethods }
     */
    public CorrelationMethods createCorrelationMethods() {
        return new CorrelationMethods();
    }

    /**
     * Create an instance of {@link Targets }
     * 
     * @return
     *     the new instance of {@link Targets }
     */
    public Targets createTargets() {
        return new Targets();
    }

    /**
     * Create an instance of {@link TargetValue }
     * 
     * @return
     *     the new instance of {@link TargetValue }
     */
    public TargetValue createTargetValue() {
        return new TargetValue();
    }

    /**
     * Create an instance of {@link Partition }
     * 
     * @return
     *     the new instance of {@link Partition }
     */
    public Partition createPartition() {
        return new Partition();
    }

    /**
     * Create an instance of {@link LocalTransformations }
     * 
     * @return
     *     the new instance of {@link LocalTransformations }
     */
    public LocalTransformations createLocalTransformations() {
        return new LocalTransformations();
    }

    /**
     * Create an instance of {@link DerivedField }
     * 
     * @return
     *     the new instance of {@link DerivedField }
     */
    public DerivedField createDerivedField() {
        return new DerivedField();
    }

    /**
     * Create an instance of {@link ResultField }
     * 
     * @return
     *     the new instance of {@link ResultField }
     */
    public ResultField createResultField() {
        return new ResultField();
    }

    /**
     * Create an instance of {@link True }
     * 
     * @return
     *     the new instance of {@link True }
     */
    public True createTrue() {
        return new True();
    }

    /**
     * Create an instance of {@link False }
     * 
     * @return
     *     the new instance of {@link False }
     */
    public False createFalse() {
        return new False();
    }

    /**
     * Create an instance of {@link ComplexScoreDistribution }
     * 
     * @return
     *     the new instance of {@link ComplexScoreDistribution }
     */
    public ComplexScoreDistribution createComplexScoreDistribution() {
        return new ComplexScoreDistribution();
    }

    /**
     * Create an instance of {@link ModelVerification }
     * 
     * @return
     *     the new instance of {@link ModelVerification }
     */
    public ModelVerification createModelVerification() {
        return new ModelVerification();
    }

    /**
     * Create an instance of {@link VerificationFields }
     * 
     * @return
     *     the new instance of {@link VerificationFields }
     */
    public VerificationFields createVerificationFields() {
        return new VerificationFields();
    }

    /**
     * Create an instance of {@link VerificationField }
     * 
     * @return
     *     the new instance of {@link VerificationField }
     */
    public VerificationField createVerificationField() {
        return new VerificationField();
    }

    /**
     * Create an instance of {@link AnyDistribution }
     * 
     * @return
     *     the new instance of {@link AnyDistribution }
     */
    public AnyDistribution createAnyDistribution() {
        return new AnyDistribution();
    }

    /**
     * Create an instance of {@link GaussianDistribution }
     * 
     * @return
     *     the new instance of {@link GaussianDistribution }
     */
    public GaussianDistribution createGaussianDistribution() {
        return new GaussianDistribution();
    }

    /**
     * Create an instance of {@link PoissonDistribution }
     * 
     * @return
     *     the new instance of {@link PoissonDistribution }
     */
    public PoissonDistribution createPoissonDistribution() {
        return new PoissonDistribution();
    }

    /**
     * Create an instance of {@link UniformDistribution }
     * 
     * @return
     *     the new instance of {@link UniformDistribution }
     */
    public UniformDistribution createUniformDistribution() {
        return new UniformDistribution();
    }

    /**
     * Create an instance of {@link Euclidean }
     * 
     * @return
     *     the new instance of {@link Euclidean }
     */
    public Euclidean createEuclidean() {
        return new Euclidean();
    }

    /**
     * Create an instance of {@link SquaredEuclidean }
     * 
     * @return
     *     the new instance of {@link SquaredEuclidean }
     */
    public SquaredEuclidean createSquaredEuclidean() {
        return new SquaredEuclidean();
    }

    /**
     * Create an instance of {@link Chebychev }
     * 
     * @return
     *     the new instance of {@link Chebychev }
     */
    public Chebychev createChebychev() {
        return new Chebychev();
    }

    /**
     * Create an instance of {@link CityBlock }
     * 
     * @return
     *     the new instance of {@link CityBlock }
     */
    public CityBlock createCityBlock() {
        return new CityBlock();
    }

    /**
     * Create an instance of {@link Minkowski }
     * 
     * @return
     *     the new instance of {@link Minkowski }
     */
    public Minkowski createMinkowski() {
        return new Minkowski();
    }

    /**
     * Create an instance of {@link SimpleMatching }
     * 
     * @return
     *     the new instance of {@link SimpleMatching }
     */
    public SimpleMatching createSimpleMatching() {
        return new SimpleMatching();
    }

    /**
     * Create an instance of {@link Jaccard }
     * 
     * @return
     *     the new instance of {@link Jaccard }
     */
    public Jaccard createJaccard() {
        return new Jaccard();
    }

    /**
     * Create an instance of {@link Tanimoto }
     * 
     * @return
     *     the new instance of {@link Tanimoto }
     */
    public Tanimoto createTanimoto() {
        return new Tanimoto();
    }

    /**
     * Create an instance of {@link BinarySimilarity }
     * 
     * @return
     *     the new instance of {@link BinarySimilarity }
     */
    public BinarySimilarity createBinarySimilarity() {
        return new BinarySimilarity();
    }

    /**
     * Create an instance of {@link RealSparseArray }
     * 
     * @return
     *     the new instance of {@link RealSparseArray }
     */
    public RealSparseArray createRealSparseArray() {
        return new RealSparseArray();
    }

    /**
     * Create an instance of {@link Taxonomy }
     * 
     * @return
     *     the new instance of {@link Taxonomy }
     */
    public Taxonomy createTaxonomy() {
        return new Taxonomy();
    }

    /**
     * Create an instance of {@link Timestamp }
     * 
     * @return
     *     the new instance of {@link Timestamp }
     */
    public Timestamp createTimestamp() {
        return new Timestamp();
    }

    /**
     * Create an instance of {@link PMML }
     * 
     * @return
     *     the new instance of {@link PMML }
     */
    public PMML createPMML() {
        return new PMML();
    }

    /**
     * Create an instance of {@link Header }
     * 
     * @return
     *     the new instance of {@link Header }
     */
    public Header createHeader() {
        return new Header();
    }

    /**
     * Create an instance of {@link Application }
     * 
     * @return
     *     the new instance of {@link Application }
     */
    public Application createApplication() {
        return new Application();
    }

    /**
     * Create an instance of {@link Annotation }
     * 
     * @return
     *     the new instance of {@link Annotation }
     */
    public Annotation createAnnotation() {
        return new Annotation();
    }

    /**
     * Create an instance of {@link MiningBuildTask }
     * 
     * @return
     *     the new instance of {@link MiningBuildTask }
     */
    public MiningBuildTask createMiningBuildTask() {
        return new MiningBuildTask();
    }

    /**
     * Create an instance of {@link DataDictionary }
     * 
     * @return
     *     the new instance of {@link DataDictionary }
     */
    public DataDictionary createDataDictionary() {
        return new DataDictionary();
    }

    /**
     * Create an instance of {@link TransformationDictionary }
     * 
     * @return
     *     the new instance of {@link TransformationDictionary }
     */
    public TransformationDictionary createTransformationDictionary() {
        return new TransformationDictionary();
    }

    /**
     * Create an instance of {@link IntSparseArray }
     * 
     * @return
     *     the new instance of {@link IntSparseArray }
     */
    public IntSparseArray createIntSparseArray() {
        return new IntSparseArray();
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CountTable }{@code >}
     * 
     * @param value
     *     Java instance representing xml element's value.
     * @return
     *     the new instance of {@link JAXBElement }{@code <}{@link CountTable }{@code >}
     */
    @XmlElementDecl(namespace = "http://www.dmg.org/PMML-4_4", name = "CountTable")
    public JAXBElement<CountTable> createCountTable(CountTable value) {
        return new JAXBElement<>(_CountTable_QNAME, CountTable.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link CountTable }{@code >}
     * 
     * @param value
     *     Java instance representing xml element's value.
     * @return
     *     the new instance of {@link JAXBElement }{@code <}{@link CountTable }{@code >}
     */
    @XmlElementDecl(namespace = "http://www.dmg.org/PMML-4_4", name = "NormalizedCountTable")
    public JAXBElement<CountTable> createNormalizedCountTable(CountTable value) {
        return new JAXBElement<>(_NormalizedCountTable_QNAME, CountTable.class, null, value);
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link List }{@code <}{@link Integer }{@code >}{@code >}
     * 
     * @param value
     *     Java instance representing xml element's value.
     * @return
     *     the new instance of {@link JAXBElement }{@code <}{@link List }{@code <}{@link Integer }{@code >}{@code >}
     */
    @XmlElementDecl(namespace = "http://www.dmg.org/PMML-4_4", name = "Indices")
    public JAXBElement<List<Integer>> createIndices(List<Integer> value) {
        return new JAXBElement<>(_Indices_QNAME, ((Class) List.class), null, ((List<Integer> ) value));
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link List }{@code <}{@link Integer }{@code >}{@code >}
     * 
     * @param value
     *     Java instance representing xml element's value.
     * @return
     *     the new instance of {@link JAXBElement }{@code <}{@link List }{@code <}{@link Integer }{@code >}{@code >}
     */
    @XmlElementDecl(namespace = "http://www.dmg.org/PMML-4_4", name = "INT-Entries")
    public JAXBElement<List<Integer>> createINTEntries(List<Integer> value) {
        return new JAXBElement<>(_INTEntries_QNAME, ((Class) List.class), null, ((List<Integer> ) value));
    }

    /**
     * Create an instance of {@link JAXBElement }{@code <}{@link List }{@code <}{@link Double }{@code >}{@code >}
     * 
     * @param value
     *     Java instance representing xml element's value.
     * @return
     *     the new instance of {@link JAXBElement }{@code <}{@link List }{@code <}{@link Double }{@code >}{@code >}
     */
    @XmlElementDecl(namespace = "http://www.dmg.org/PMML-4_4", name = "REAL-Entries")
    public JAXBElement<List<Double>> createREALEntries(List<Double> value) {
        return new JAXBElement<>(_REALEntries_QNAME, ((Class) List.class), null, ((List<Double> ) value));
    }

}
