
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.ContinuousDistribution;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Baseline", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "continuousDistribution",
    "countTable",
    "normalizedCountTable",
    "fieldRefs"
})
@JsonRootName("Baseline")
@JsonPropertyOrder({
    "continuousDistribution",
    "countTable",
    "normalizedCountTable",
    "fieldRefs"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class Baseline
    extends org.dmg.pmml.PMMLObject
{

    @XmlElements({
        @XmlElement(name = "AnyDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.AnyDistribution.class),
        @XmlElement(name = "GaussianDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.GaussianDistribution.class),
        @XmlElement(name = "PoissonDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.PoissonDistribution.class),
        @XmlElement(name = "UniformDistribution", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.UniformDistribution.class)
    })
    @JsonProperty("ContinuousDistribution")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "AnyDistribution", value = org.dmg.pmml.AnyDistribution.class),
        @JsonSubTypes.Type(name = "GaussianDistribution", value = org.dmg.pmml.GaussianDistribution.class),
        @JsonSubTypes.Type(name = "PoissonDistribution", value = org.dmg.pmml.PoissonDistribution.class),
        @JsonSubTypes.Type(name = "UniformDistribution", value = org.dmg.pmml.UniformDistribution.class)
    })
    private ContinuousDistribution continuousDistribution;
    @XmlElement(name = "CountTable", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("CountTable")
    private CountTable countTable;
    @XmlElement(name = "NormalizedCountTable", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("NormalizedCountTable")
    private CountTable normalizedCountTable;
    @XmlElement(name = "FieldRef", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("FieldRef")
    @CollectionElementType(FieldRef.class)
    private List<FieldRef> fieldRefs;
    private static final long serialVersionUID = 67371272L;

    public Baseline() {
    }

    @ValueConstructor
    public Baseline(
        @org.jpmml.model.annotations.Property("continuousDistribution")
        ContinuousDistribution continuousDistribution,
        @org.jpmml.model.annotations.Property("countTable")
        CountTable countTable,
        @org.jpmml.model.annotations.Property("normalizedCountTable")
        CountTable normalizedCountTable,
        @org.jpmml.model.annotations.Property("fieldRefs")
        List<FieldRef> fieldRefs) {
        this.continuousDistribution = continuousDistribution;
        this.countTable = countTable;
        this.normalizedCountTable = normalizedCountTable;
        this.fieldRefs = fieldRefs;
    }

    public ContinuousDistribution requireContinuousDistribution() {
        if (this.continuousDistribution == null) {
            throw new MissingElementException(this, PMMLElements.BASELINE_CONTINUOUSDISTRIBUTION);
        }
        return this.continuousDistribution;
    }

    public ContinuousDistribution getContinuousDistribution() {
        return continuousDistribution;
    }

    public Baseline setContinuousDistribution(
        @org.jpmml.model.annotations.Property("continuousDistribution")
        ContinuousDistribution continuousDistribution) {
        this.continuousDistribution = continuousDistribution;
        return this;
    }

    public CountTable requireCountTable() {
        if (this.countTable == null) {
            throw new MissingElementException(this, PMMLElements.BASELINE_COUNTTABLE);
        }
        return this.countTable;
    }

    public CountTable getCountTable() {
        return countTable;
    }

    public Baseline setCountTable(
        @org.jpmml.model.annotations.Property("countTable")
        CountTable countTable) {
        this.countTable = countTable;
        return this;
    }

    public CountTable requireNormalizedCountTable() {
        if (this.normalizedCountTable == null) {
            throw new MissingElementException(this, PMMLElements.BASELINE_NORMALIZEDCOUNTTABLE);
        }
        return this.normalizedCountTable;
    }

    public CountTable getNormalizedCountTable() {
        return normalizedCountTable;
    }

    public Baseline setNormalizedCountTable(
        @org.jpmml.model.annotations.Property("normalizedCountTable")
        CountTable normalizedCountTable) {
        this.normalizedCountTable = normalizedCountTable;
        return this;
    }

    public boolean hasFieldRefs() {
        return ((this.fieldRefs!= null)&&(!this.fieldRefs.isEmpty()));
    }

    public List<FieldRef> requireFieldRefs() {
        if ((this.fieldRefs == null)||this.fieldRefs.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BASELINE_FIELDREFS);
        }
        return this.fieldRefs;
    }

    public List<FieldRef> getFieldRefs() {
        if (fieldRefs == null) {
            fieldRefs = new ArrayList<>();
        }
        return this.fieldRefs;
    }

    public Baseline addFieldRefs(FieldRef... fieldRefs) {
        getFieldRefs().addAll(Arrays.asList(fieldRefs));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistribution(), getCountTable(), getNormalizedCountTable());
            }
            if ((status == VisitorAction.CONTINUE)&&hasFieldRefs()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getFieldRefs());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
