
package org.dmg.pmml.baseline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.HasValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.AlternateValueConstructor;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "FieldValueCount", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("FieldValueCount")
@JsonPropertyOrder({
    "field",
    "value",
    "count",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_1))
public class FieldValueCount
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<FieldValueCount> , HasFieldReference<FieldValueCount> , HasValue<FieldValueCount>
{

    @XmlAttribute(name = "field", required = true)
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    private String field;
    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "count", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("count")
    private Number count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public FieldValueCount() {
    }

    @ValueConstructor
    public FieldValueCount(
        @org.jpmml.model.annotations.Property("field")
        String field,
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("count")
        Number count) {
        this.field = field;
        this.value = value;
        this.count = count;
    }

    @AlternateValueConstructor
    public FieldValueCount(Field<?> field, Object value, Number count) {
        this(((field!= null)?field.requireName():null), value, count);
    }

    @Override
    public String requireField() {
        if (this.field == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDVALUECOUNT_FIELD);
        }
        return this.field;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public FieldValueCount setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDVALUECOUNT_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public FieldValueCount setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    public Number requireCount() {
        if (this.count == null) {
            throw new MissingAttributeException(this, PMMLAttributes.FIELDVALUECOUNT_COUNT);
        }
        return this.count;
    }

    public Number getCount() {
        return count;
    }

    public FieldValueCount setCount(
        @org.jpmml.model.annotations.Property("count")
        Number count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public FieldValueCount addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
