
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ContinuousConditionalProbability", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "parentValues",
    "continuousDistributions"
})
@JsonRootName("ContinuousConditionalProbability")
@JsonPropertyOrder({
    "count",
    "extensions",
    "parentValues",
    "continuousDistributions"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
public class ContinuousConditionalProbability
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<ContinuousConditionalProbability>
{

    @XmlAttribute(name = "count")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("count")
    private Number count;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "ParentValue", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("ParentValue")
    @CollectionElementType(ParentValue.class)
    private List<ParentValue> parentValues;
    @XmlElement(name = "ContinuousDistribution", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("ContinuousDistribution")
    @CollectionElementType(ContinuousDistribution.class)
    private List<ContinuousDistribution> continuousDistributions;
    private static final long serialVersionUID = 67371272L;

    public ContinuousConditionalProbability() {
    }

    @ValueConstructor
    public ContinuousConditionalProbability(
        @org.jpmml.model.annotations.Property("continuousDistributions")
        List<ContinuousDistribution> continuousDistributions) {
        this.continuousDistributions = continuousDistributions;
    }

    public Number getCount() {
        return count;
    }

    public ContinuousConditionalProbability setCount(
        @org.jpmml.model.annotations.Property("count")
        Number count) {
        this.count = count;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public ContinuousConditionalProbability addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasParentValues() {
        return ((this.parentValues!= null)&&(!this.parentValues.isEmpty()));
    }

    public List<ParentValue> getParentValues() {
        if (parentValues == null) {
            parentValues = new ArrayList<>();
        }
        return this.parentValues;
    }

    public ContinuousConditionalProbability addParentValues(ParentValue... parentValues) {
        getParentValues().addAll(Arrays.asList(parentValues));
        return this;
    }

    public boolean hasContinuousDistributions() {
        return ((this.continuousDistributions!= null)&&(!this.continuousDistributions.isEmpty()));
    }

    public List<ContinuousDistribution> requireContinuousDistributions() {
        if ((this.continuousDistributions == null)||this.continuousDistributions.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.CONTINUOUSCONDITIONALPROBABILITY_CONTINUOUSDISTRIBUTIONS);
        }
        return this.continuousDistributions;
    }

    public List<ContinuousDistribution> getContinuousDistributions() {
        if (continuousDistributions == null) {
            continuousDistributions = new ArrayList<>();
        }
        return this.continuousDistributions;
    }

    public ContinuousConditionalProbability addContinuousDistributions(ContinuousDistribution... continuousDistributions) {
        getContinuousDistributions().addAll(Arrays.asList(continuousDistributions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasParentValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getParentValues());
            }
            if ((status == VisitorAction.CONTINUE)&&hasContinuousDistributions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getContinuousDistributions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
