
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "BaseCumHazardTables", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "baselineStrata",
    "baselineCells"
})
@JsonRootName("BaseCumHazardTables")
@JsonPropertyOrder({
    "maxTime",
    "extensions",
    "baselineStrata",
    "baselineCells"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class BaseCumHazardTables
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<BaseCumHazardTables>
{

    @XmlAttribute(name = "maxTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("maxTime")
    private Number maxTime;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "BaselineStratum", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("BaselineStratum")
    @CollectionElementType(BaselineStratum.class)
    private List<BaselineStratum> baselineStrata;
    @XmlElement(name = "BaselineCell", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("BaselineCell")
    @CollectionElementType(BaselineCell.class)
    private List<BaselineCell> baselineCells;
    private static final long serialVersionUID = 67371272L;

    public BaseCumHazardTables() {
    }

    @ValueConstructor
    public BaseCumHazardTables(
        @org.jpmml.model.annotations.Property("baselineStrata")
        List<BaselineStratum> baselineStrata,
        @org.jpmml.model.annotations.Property("baselineCells")
        List<BaselineCell> baselineCells) {
        this.baselineStrata = baselineStrata;
        this.baselineCells = baselineCells;
    }

    public Number requireMaxTime() {
        if (this.maxTime == null) {
            throw new MissingAttributeException(this, PMMLAttributes.BASECUMHAZARDTABLES_MAXTIME);
        }
        return this.maxTime;
    }

    public Number getMaxTime() {
        return maxTime;
    }

    public BaseCumHazardTables setMaxTime(
        @org.jpmml.model.annotations.Property("maxTime")
        Number maxTime) {
        this.maxTime = maxTime;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public BaseCumHazardTables addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasBaselineStrata() {
        return ((this.baselineStrata!= null)&&(!this.baselineStrata.isEmpty()));
    }

    public List<BaselineStratum> requireBaselineStrata() {
        if ((this.baselineStrata == null)||this.baselineStrata.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BASECUMHAZARDTABLES_BASELINESTRATA);
        }
        return this.baselineStrata;
    }

    public List<BaselineStratum> getBaselineStrata() {
        if (baselineStrata == null) {
            baselineStrata = new ArrayList<>();
        }
        return this.baselineStrata;
    }

    public BaseCumHazardTables addBaselineStrata(BaselineStratum... baselineStrata) {
        getBaselineStrata().addAll(Arrays.asList(baselineStrata));
        return this;
    }

    public boolean hasBaselineCells() {
        return ((this.baselineCells!= null)&&(!this.baselineCells.isEmpty()));
    }

    public List<BaselineCell> requireBaselineCells() {
        if ((this.baselineCells == null)||this.baselineCells.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.BASECUMHAZARDTABLES_BASELINECELLS);
        }
        return this.baselineCells;
    }

    public List<BaselineCell> getBaselineCells() {
        if (baselineCells == null) {
            baselineCells = new ArrayList<>();
        }
        return this.baselineCells;
    }

    public BaseCumHazardTables addBaselineCells(BaselineCell... baselineCells) {
        getBaselineCells().addAll(Arrays.asList(baselineCells));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBaselineStrata()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaselineStrata());
            }
            if ((status == VisitorAction.CONTINUE)&&hasBaselineCells()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getBaselineCells());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
