
package org.dmg.pmml.general_regression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.IntegerAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "PCell", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("PCell")
@JsonPropertyOrder({
    "targetCategory",
    "parameterName",
    "beta",
    "df",
    "extensions"
})
public class PCell
    extends ParameterCell
    implements HasExtensions<PCell>
{

    @XmlAttribute(name = "targetCategory")
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("targetCategory")
    private Object targetCategory;
    @XmlAttribute(name = "parameterName", required = true)
    @JsonProperty("parameterName")
    private String parameterName;
    @XmlAttribute(name = "beta", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("beta")
    private Number beta;
    @XmlAttribute(name = "df")
    @XmlJavaTypeAdapter(IntegerAdapter.class)
    @JsonProperty("df")
    private Integer df;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public PCell() {
    }

    @ValueConstructor
    public PCell(
        @org.jpmml.model.annotations.Property("parameterName")
        String parameterName,
        @org.jpmml.model.annotations.Property("beta")
        Number beta) {
        this.parameterName = parameterName;
        this.beta = beta;
    }

    @Override
    public Object getTargetCategory() {
        return targetCategory;
    }

    @Override
    public PCell setTargetCategory(
        @org.jpmml.model.annotations.Property("targetCategory")
        Object targetCategory) {
        this.targetCategory = targetCategory;
        return this;
    }

    @Override
    public String requireParameterName() {
        if (this.parameterName == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PCELL_PARAMETERNAME);
        }
        return this.parameterName;
    }

    @Override
    public String getParameterName() {
        return parameterName;
    }

    @Override
    public PCell setParameterName(
        @org.jpmml.model.annotations.Property("parameterName")
        String parameterName) {
        this.parameterName = parameterName;
        return this;
    }

    public Number requireBeta() {
        if (this.beta == null) {
            throw new MissingAttributeException(this, PMMLAttributes.PCELL_BETA);
        }
        return this.beta;
    }

    public Number getBeta() {
        return beta;
    }

    public PCell setBeta(
        @org.jpmml.model.annotations.Property("beta")
        Number beta) {
        this.beta = beta;
        return this;
    }

    public Integer getDf() {
        return df;
    }

    public PCell setDf(
        @org.jpmml.model.annotations.Property("df")
        Integer df) {
        this.df = df;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public PCell addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
