
package org.dmg.pmml.support_vector_machine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.CollectionSize;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "SupportVectors", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "supportVectors"
})
@JsonRootName("SupportVectors")
@JsonPropertyOrder({
    "numberOfSupportVectors",
    "numberOfAttributes",
    "extensions",
    "supportVectors"
})
public class SupportVectors
    extends org.dmg.pmml.PMMLObject
    implements Iterable<SupportVector> , HasExtensions<SupportVectors>
{

    @XmlAttribute(name = "numberOfSupportVectors")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfSupportVectors")
    @CollectionSize(("supportVectors"))
    private Integer numberOfSupportVectors;
    @XmlAttribute(name = "numberOfAttributes")
    @XmlJavaTypeAdapter(NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name = "nonNegativeInteger")
    @JsonProperty("numberOfAttributes")
    private Integer numberOfAttributes;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "SupportVector", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("SupportVector")
    @CollectionElementType(SupportVector.class)
    private List<SupportVector> supportVectors;
    private static final long serialVersionUID = 67371272L;

    public SupportVectors() {
    }

    @ValueConstructor
    public SupportVectors(
        @org.jpmml.model.annotations.Property("supportVectors")
        List<SupportVector> supportVectors) {
        this.supportVectors = supportVectors;
    }

    public Integer getNumberOfSupportVectors() {
        return numberOfSupportVectors;
    }

    public SupportVectors setNumberOfSupportVectors(
        @org.jpmml.model.annotations.Property("numberOfSupportVectors")
        Integer numberOfSupportVectors) {
        this.numberOfSupportVectors = numberOfSupportVectors;
        return this;
    }

    public Integer getNumberOfAttributes() {
        return numberOfAttributes;
    }

    public SupportVectors setNumberOfAttributes(
        @org.jpmml.model.annotations.Property("numberOfAttributes")
        Integer numberOfAttributes) {
        this.numberOfAttributes = numberOfAttributes;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public SupportVectors addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Iterator<SupportVector> iterator() {
        return requireSupportVectors().iterator();
    }

    public boolean hasSupportVectors() {
        return ((this.supportVectors!= null)&&(!this.supportVectors.isEmpty()));
    }

    public List<SupportVector> requireSupportVectors() {
        if ((this.supportVectors == null)||this.supportVectors.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.SUPPORTVECTORS_SUPPORTVECTORS);
        }
        return this.supportVectors;
    }

    public List<SupportVector> getSupportVectors() {
        if (supportVectors == null) {
            supportVectors = new ArrayList<>();
        }
        return this.supportVectors;
    }

    public SupportVectors addSupportVectors(SupportVector... supportVectors) {
        getSupportVectors().addAll(Arrays.asList(supportVectors));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasSupportVectors()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getSupportVectors());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
