
package org.dmg.pmml.time_series;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.HasFieldReference;
import org.dmg.pmml.StringValue;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Removed;
import org.jpmml.model.annotations.Required;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "TimeSeries", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "timeAnchor",
    "timeExceptions",
    "timeValues"
})
@JsonRootName("TimeSeries")
@JsonPropertyOrder({
    "usage",
    "startTime",
    "endTime",
    "interpolationMethod",
    "field",
    "timeAnchor",
    "timeExceptions",
    "timeValues"
})
@org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_0))
public class TimeSeries
    extends org.dmg.pmml.PMMLObject
    implements HasFieldReference<TimeSeries>
{

    @XmlAttribute(name = "usage")
    @JsonProperty("usage")
    private TimeSeries.Usage usage;
    @XmlAttribute(name = "startTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("startTime")
    private Number startTime;
    @XmlAttribute(name = "endTime")
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("endTime")
    private Number endTime;
    @XmlAttribute(name = "interpolationMethod")
    @JsonProperty("interpolationMethod")
    private TimeSeries.InterpolationMethod interpolationMethod;
    @XmlAttribute(name = "field")
    @XmlJavaTypeAdapter(FieldNameAdapter.class)
    @JsonProperty("field")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_4))
    private String field;
    @XmlElement(name = "TimeAnchor", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TimeAnchor")
    private TimeAnchor timeAnchor;
    @XmlElement(name = "TimeException", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("TimeException")
    @Removed((org.dmg.pmml.Version.PMML_4_1))
    @CollectionElementType(TimeException.class)
    private List<TimeException> timeExceptions;
    @XmlElement(name = "TimeValue", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("TimeValue")
    @Required((org.dmg.pmml.Version.PMML_4_4))
    @CollectionElementType(TimeValue.class)
    private List<TimeValue> timeValues;
    private static final long serialVersionUID = 67371272L;

    public TimeSeries() {
    }

    @ValueConstructor
    public TimeSeries(
        @org.jpmml.model.annotations.Property("timeValues")
        List<TimeValue> timeValues) {
        this.timeValues = timeValues;
    }

    public TimeSeries.Usage getUsage() {
        if (usage == null) {
            return TimeSeries.Usage.ORIGINAL;
        } else {
            return usage;
        }
    }

    public TimeSeries setUsage(
        @org.jpmml.model.annotations.Property("usage")
        TimeSeries.Usage usage) {
        this.usage = usage;
        return this;
    }

    public Number getStartTime() {
        return startTime;
    }

    public TimeSeries setStartTime(
        @org.jpmml.model.annotations.Property("startTime")
        Number startTime) {
        this.startTime = startTime;
        return this;
    }

    public Number getEndTime() {
        return endTime;
    }

    public TimeSeries setEndTime(
        @org.jpmml.model.annotations.Property("endTime")
        Number endTime) {
        this.endTime = endTime;
        return this;
    }

    public TimeSeries.InterpolationMethod getInterpolationMethod() {
        if (interpolationMethod == null) {
            return TimeSeries.InterpolationMethod.NONE;
        } else {
            return interpolationMethod;
        }
    }

    public TimeSeries setInterpolationMethod(
        @org.jpmml.model.annotations.Property("interpolationMethod")
        TimeSeries.InterpolationMethod interpolationMethod) {
        this.interpolationMethod = interpolationMethod;
        return this;
    }

    @Override
    public String getField() {
        return field;
    }

    @Override
    public TimeSeries setField(
        @org.jpmml.model.annotations.Property("field")
        String field) {
        this.field = field;
        return this;
    }

    public TimeAnchor getTimeAnchor() {
        return timeAnchor;
    }

    public TimeSeries setTimeAnchor(
        @org.jpmml.model.annotations.Property("timeAnchor")
        TimeAnchor timeAnchor) {
        this.timeAnchor = timeAnchor;
        return this;
    }

    public boolean hasTimeExceptions() {
        return ((this.timeExceptions!= null)&&(!this.timeExceptions.isEmpty()));
    }

    public List<TimeException> getTimeExceptions() {
        if (timeExceptions == null) {
            timeExceptions = new ArrayList<>();
        }
        return this.timeExceptions;
    }

    public TimeSeries addTimeExceptions(TimeException... timeExceptions) {
        getTimeExceptions().addAll(Arrays.asList(timeExceptions));
        return this;
    }

    public boolean hasTimeValues() {
        return ((this.timeValues!= null)&&(!this.timeValues.isEmpty()));
    }

    public List<TimeValue> requireTimeValues() {
        if ((this.timeValues == null)||this.timeValues.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.TIMESERIES_TIMEVALUES);
        }
        return this.timeValues;
    }

    public List<TimeValue> getTimeValues() {
        if (timeValues == null) {
            timeValues = new ArrayList<>();
        }
        return this.timeValues;
    }

    public TimeSeries addTimeValues(TimeValue... timeValues) {
        getTimeValues().addAll(Arrays.asList(timeValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeAnchor());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeExceptions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeExceptions());
            }
            if ((status == VisitorAction.CONTINUE)&&hasTimeValues()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getTimeValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum InterpolationMethod
        implements StringValue<TimeSeries.InterpolationMethod>
    {

        @XmlEnumValue("none")
        @JsonProperty("none")
        NONE("none"),
        @XmlEnumValue("linear")
        @JsonProperty("linear")
        LINEAR("linear"),
        @XmlEnumValue("exponentialSpline")
        @JsonProperty("exponentialSpline")
        EXPONENTIAL_SPLINE("exponentialSpline"),
        @XmlEnumValue("cubicSpline")
        @JsonProperty("cubicSpline")
        CUBIC_SPLINE("cubicSpline");
        private final String value;

        InterpolationMethod(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TimeSeries.InterpolationMethod fromValue(String v) {
            for (TimeSeries.InterpolationMethod c: TimeSeries.InterpolationMethod.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

    @XmlType(name = "")
    @XmlEnum
    public enum Usage
        implements StringValue<TimeSeries.Usage>
    {

        @XmlEnumValue("original")
        @JsonProperty("original")
        ORIGINAL("original"),
        @XmlEnumValue("logical")
        @JsonProperty("logical")
        LOGICAL("logical"),
        @XmlEnumValue("prediction")
        @JsonProperty("prediction")
        PREDICTION("prediction");
        private final String value;

        Usage(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static TimeSeries.Usage fromValue(String v) {
            for (TimeSeries.Usage c: TimeSeries.Usage.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
