
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Value", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Value")
@JsonPropertyOrder({
    "value",
    "displayValue",
    "property",
    "extensions"
})
public class Value
    extends org.dmg.pmml.PMMLObject
    implements HasDisplayValue<Value> , HasExtensions<Value> , HasValue<Value>
{

    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "displayValue")
    @JsonProperty("displayValue")
    private String displayValue;
    @XmlAttribute(name = "property")
    @JsonProperty("property")
    private Value.Property property;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public Value() {
    }

    @ValueConstructor
    public Value(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.VALUE_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public Value setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public String getDisplayValue() {
        return displayValue;
    }

    @Override
    public Value setDisplayValue(
        @org.jpmml.model.annotations.Property("displayValue")
        String displayValue) {
        this.displayValue = displayValue;
        return this;
    }

    public Value.Property getProperty() {
        if (property == null) {
            return Value.Property.VALID;
        } else {
            return property;
        }
    }

    public Value setProperty(
        @org.jpmml.model.annotations.Property("property")
        Value.Property property) {
        this.property = property;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Value addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Property
        implements StringValue<Value.Property>
    {

        @XmlEnumValue("valid")
        @JsonProperty("valid")
        VALID("valid"),
        @XmlEnumValue("invalid")
        @JsonProperty("invalid")
        INVALID("invalid"),
        @XmlEnumValue("missing")
        @JsonProperty("missing")
        MISSING("missing");
        private final String value;

        Property(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static Value.Property fromValue(String v) {
            for (Value.Property c: Value.Property.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
