
package org.dmg.pmml.bayesian_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "NormalDistributionForBN", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "mean",
    "variance"
})
@JsonRootName("NormalDistributionForBN")
@JsonPropertyOrder({
    "extensions",
    "mean",
    "variance"
})
@Added((org.dmg.pmml.Version.PMML_4_3))
public class NormalDistribution
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<NormalDistribution>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElement(name = "Mean", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Mean")
    private Mean mean;
    @XmlElement(name = "Variance", namespace = "http://www.dmg.org/PMML-4_4", required = true)
    @JsonProperty("Variance")
    private Variance variance;
    private static final long serialVersionUID = 67371272L;

    public NormalDistribution() {
    }

    @ValueConstructor
    public NormalDistribution(
        @org.jpmml.model.annotations.Property("mean")
        Mean mean,
        @org.jpmml.model.annotations.Property("variance")
        Variance variance) {
        this.mean = mean;
        this.variance = variance;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public NormalDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public Mean requireMean() {
        if (this.mean == null) {
            throw new MissingElementException(this, PMMLElements.NORMALDISTRIBUTION_MEAN);
        }
        return this.mean;
    }

    public Mean getMean() {
        return mean;
    }

    public NormalDistribution setMean(
        @org.jpmml.model.annotations.Property("mean")
        Mean mean) {
        this.mean = mean;
        return this;
    }

    public Variance requireVariance() {
        if (this.variance == null) {
            throw new MissingElementException(this, PMMLElements.NORMALDISTRIBUTION_VARIANCE);
        }
        return this.variance;
    }

    public Variance getVariance() {
        return variance;
    }

    public NormalDistribution setVariance(
        @org.jpmml.model.annotations.Property("variance")
        Variance variance) {
        this.variance = variance;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getMean(), getVariance());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
