
package org.dmg.pmml.neural_network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.RealNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "Con", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("Con")
@JsonPropertyOrder({
    "from",
    "weight",
    "extensions"
})
public class Connection
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<Connection>
{

    @XmlAttribute(name = "from", required = true)
    @JsonProperty("from")
    private String from;
    @XmlAttribute(name = "weight", required = true)
    @XmlJavaTypeAdapter(RealNumberAdapter.class)
    @JsonProperty("weight")
    private Number weight;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public Connection() {
    }

    @ValueConstructor
    public Connection(
        @org.jpmml.model.annotations.Property("from")
        String from,
        @org.jpmml.model.annotations.Property("weight")
        Number weight) {
        this.from = from;
        this.weight = weight;
    }

    public String requireFrom() {
        if (this.from == null) {
            throw new MissingAttributeException(this, PMMLAttributes.CONNECTION_FROM);
        }
        return this.from;
    }

    public String getFrom() {
        return from;
    }

    public Connection setFrom(
        @org.jpmml.model.annotations.Property("from")
        String from) {
        this.from = from;
        return this;
    }

    public Number requireWeight() {
        if (this.weight == null) {
            throw new MissingAttributeException(this, PMMLAttributes.CONNECTION_WEIGHT);
        }
        return this.weight;
    }

    public Number getWeight() {
        return weight;
    }

    public Connection setWeight(
        @org.jpmml.model.annotations.Property("weight")
        Number weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public Connection addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
