
package org.dmg.pmml.rule_set;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "CompoundRule", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions",
    "predicate",
    "rules"
})
@JsonRootName("CompoundRule")
@JsonPropertyOrder({
    "extensions",
    "predicate",
    "rules"
})
public class CompoundRule
    extends org.dmg.pmml.rule_set.Rule
    implements HasExtensions<CompoundRule>
{

    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    @XmlElements({
        @XmlElement(name = "SimplePredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimplePredicate.class),
        @XmlElement(name = "CompoundPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.CompoundPredicate.class),
        @XmlElement(name = "SimpleSetPredicate", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.SimpleSetPredicate.class),
        @XmlElement(name = "True", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.True.class),
        @XmlElement(name = "False", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.False.class)
    })
    @JsonProperty("Predicate")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimplePredicate", value = org.dmg.pmml.SimplePredicate.class),
        @JsonSubTypes.Type(name = "CompoundPredicate", value = org.dmg.pmml.CompoundPredicate.class),
        @JsonSubTypes.Type(name = "SimpleSetPredicate", value = org.dmg.pmml.SimpleSetPredicate.class),
        @JsonSubTypes.Type(name = "True", value = org.dmg.pmml.True.class),
        @JsonSubTypes.Type(name = "False", value = org.dmg.pmml.False.class)
    })
    private Predicate predicate;
    @XmlElements({
        @XmlElement(name = "SimpleRule", namespace = "http://www.dmg.org/PMML-4_4", type = org.dmg.pmml.rule_set.SimpleRule.class),
        @XmlElement(name = "CompoundRule", namespace = "http://www.dmg.org/PMML-4_4", type = CompoundRule.class)
    })
    @JsonProperty("Rule")
    @JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
    @JsonSubTypes({
        @JsonSubTypes.Type(name = "SimpleRule", value = org.dmg.pmml.rule_set.SimpleRule.class),
        @JsonSubTypes.Type(name = "CompoundRule", value = org.dmg.pmml.rule_set.CompoundRule.class)
    })
    @CollectionElementType(org.dmg.pmml.rule_set.Rule.class)
    private List<org.dmg.pmml.rule_set.Rule> rules;
    private static final long serialVersionUID = 67371272L;

    public CompoundRule() {
    }

    @ValueConstructor
    public CompoundRule(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate,
        @org.jpmml.model.annotations.Property("rules")
        List<org.dmg.pmml.rule_set.Rule> rules) {
        this.predicate = predicate;
        this.rules = rules;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public CompoundRule addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public Predicate requirePredicate() {
        if (this.predicate == null) {
            throw new MissingElementException(this, PMMLElements.COMPOUNDRULE_PREDICATE);
        }
        return this.predicate;
    }

    @Override
    public Predicate getPredicate() {
        return predicate;
    }

    @Override
    public CompoundRule setPredicate(
        @org.jpmml.model.annotations.Property("predicate")
        Predicate predicate) {
        this.predicate = predicate;
        return this;
    }

    public boolean hasRules() {
        return ((this.rules!= null)&&(!this.rules.isEmpty()));
    }

    public List<org.dmg.pmml.rule_set.Rule> requireRules() {
        if ((this.rules == null)||this.rules.isEmpty()) {
            throw new MissingElementException(this, PMMLElements.COMPOUNDRULE_RULES);
        }
        return this.rules;
    }

    public List<org.dmg.pmml.rule_set.Rule> getRules() {
        if (rules == null) {
            rules = new ArrayList<>();
        }
        return this.rules;
    }

    public CompoundRule addRules(org.dmg.pmml.rule_set.Rule... rules) {
        getRules().addAll(Arrays.asList(rules));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, getPredicate());
            }
            if ((status == VisitorAction.CONTINUE)&&hasRules()) {
                status = PMMLObject.traverse(visitor, getRules());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
