/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml.clustering;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.Entity;
import org.dmg.pmml.Extension;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.HasName;
import org.dmg.pmml.HasRequiredArray;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Partition;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.NonNegativeIntegerAdapter;
import org.dmg.pmml.clustering.Covariances;
import org.dmg.pmml.clustering.KohonenMap;
import org.dmg.pmml.clustering.PMMLElements;
import org.jpmml.model.MissingElementException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.Property;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name="Cluster", namespace="http://www.dmg.org/PMML-4_4")
@XmlType(name="", propOrder={"extensions", "kohonenMap", "array", "partition", "covariances"})
@JsonRootName(value="Cluster")
@JsonPropertyOrder(value={"id", "name", "size", "extensions", "kohonenMap", "array", "partition", "covariances"})
public class Cluster
extends Entity<String>
implements HasExtensions<Cluster>,
HasName<Cluster>,
HasRequiredArray<Cluster> {
    @XmlAttribute(name="id")
    @JsonProperty(value="id")
    @Added(value=Version.PMML_4_1)
    private String id;
    @XmlAttribute(name="name")
    @JsonProperty(value="name")
    private String name;
    @XmlAttribute(name="size")
    @XmlJavaTypeAdapter(value=NonNegativeIntegerAdapter.class)
    @XmlSchemaType(name="nonNegativeInteger")
    @JsonProperty(value="size")
    private Integer size;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Extension")
    @CollectionElementType(value=Extension.class)
    private List<Extension> extensions;
    @XmlElement(name="KohonenMap", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="KohonenMap")
    private KohonenMap kohonenMap;
    @XmlElement(name="Array", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Array")
    private Array array;
    @XmlElement(name="Partition", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Partition")
    private Partition partition;
    @XmlElement(name="Covariances", namespace="http://www.dmg.org/PMML-4_4")
    @JsonProperty(value="Covariances")
    private Covariances covariances;
    private static final long serialVersionUID = 67371272L;

    public Cluster() {
    }

    @ValueConstructor
    public Cluster(@Property(value="array") Array array) {
        this.array = array;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Cluster setId(@Property(value="id") String id) {
        this.id = id;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Cluster setName(@Property(value="name") String name) {
        this.name = name;
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public Cluster setSize(@Property(value="size") Integer size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public Cluster addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public KohonenMap getKohonenMap() {
        return this.kohonenMap;
    }

    public Cluster setKohonenMap(@Property(value="kohonenMap") KohonenMap kohonenMap) {
        this.kohonenMap = kohonenMap;
        return this;
    }

    @Override
    public Array requireArray() {
        if (this.array == null) {
            throw new MissingElementException(this, PMMLElements.CLUSTER_ARRAY);
        }
        return this.array;
    }

    @Override
    public Array getArray() {
        return this.array;
    }

    @Override
    public Cluster setArray(@Property(value="array") Array array) {
        this.array = array;
        return this;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Cluster setPartition(@Property(value="partition") Partition partition) {
        this.partition = partition;
        return this;
    }

    public Covariances getCovariances() {
        return this.covariances;
    }

    public Cluster setCovariances(@Property(value="covariances") Covariances covariances) {
        this.covariances = covariances;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getKohonenMap(), this.getArray(), this.getPartition(), this.getCovariances());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

