
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.Added;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "AnovaRow", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("AnovaRow")
@JsonPropertyOrder({
    "type",
    "sumOfSquares",
    "degreesOfFreedom",
    "meanOfSquares",
    "fValue",
    "pValue",
    "extensions"
})
@Added((org.dmg.pmml.Version.PMML_4_0))
public class AnovaRow
    extends org.dmg.pmml.PMMLObject
    implements HasExtensions<AnovaRow>
{

    @XmlAttribute(name = "type", required = true)
    @JsonProperty("type")
    private AnovaRow.Type type;
    @XmlAttribute(name = "sumOfSquares", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("sumOfSquares")
    private Number sumOfSquares;
    @XmlAttribute(name = "degreesOfFreedom", required = true)
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("degreesOfFreedom")
    private Number degreesOfFreedom;
    @XmlAttribute(name = "meanOfSquares")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("meanOfSquares")
    private Number meanOfSquares;
    @XmlAttribute(name = "fValue")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("fValue")
    private Number fValue;
    @XmlAttribute(name = "pValue")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("pValue")
    private Number pValue;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public AnovaRow() {
    }

    @ValueConstructor
    public AnovaRow(
        @org.jpmml.model.annotations.Property("type")
        AnovaRow.Type type,
        @org.jpmml.model.annotations.Property("sumOfSquares")
        Number sumOfSquares,
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        Number degreesOfFreedom) {
        this.type = type;
        this.sumOfSquares = sumOfSquares;
        this.degreesOfFreedom = degreesOfFreedom;
    }

    public AnovaRow.Type requireType() {
        if (this.type == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANOVAROW_TYPE);
        }
        return this.type;
    }

    public AnovaRow.Type getType() {
        return type;
    }

    public AnovaRow setType(
        @org.jpmml.model.annotations.Property("type")
        AnovaRow.Type type) {
        this.type = type;
        return this;
    }

    public Number requireSumOfSquares() {
        if (this.sumOfSquares == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANOVAROW_SUMOFSQUARES);
        }
        return this.sumOfSquares;
    }

    public Number getSumOfSquares() {
        return sumOfSquares;
    }

    public AnovaRow setSumOfSquares(
        @org.jpmml.model.annotations.Property("sumOfSquares")
        Number sumOfSquares) {
        this.sumOfSquares = sumOfSquares;
        return this;
    }

    public Number requireDegreesOfFreedom() {
        if (this.degreesOfFreedom == null) {
            throw new MissingAttributeException(this, PMMLAttributes.ANOVAROW_DEGREESOFFREEDOM);
        }
        return this.degreesOfFreedom;
    }

    public Number getDegreesOfFreedom() {
        return degreesOfFreedom;
    }

    public AnovaRow setDegreesOfFreedom(
        @org.jpmml.model.annotations.Property("degreesOfFreedom")
        Number degreesOfFreedom) {
        this.degreesOfFreedom = degreesOfFreedom;
        return this;
    }

    public Number getMeanOfSquares() {
        return meanOfSquares;
    }

    public AnovaRow setMeanOfSquares(
        @org.jpmml.model.annotations.Property("meanOfSquares")
        Number meanOfSquares) {
        this.meanOfSquares = meanOfSquares;
        return this;
    }

    public Number getFValue() {
        return fValue;
    }

    public AnovaRow setFValue(
        @org.jpmml.model.annotations.Property("fValue")
        Number fValue) {
        this.fValue = fValue;
        return this;
    }

    public Number getPValue() {
        return pValue;
    }

    public AnovaRow setPValue(
        @org.jpmml.model.annotations.Property("pValue")
        Number pValue) {
        this.pValue = pValue;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public AnovaRow addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = org.dmg.pmml.PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name = "")
    @XmlEnum
    public enum Type
        implements StringValue<AnovaRow.Type>
    {

        @XmlEnumValue("Model")
        @JsonProperty("Model")
        MODEL("Model"),
        @XmlEnumValue("Error")
        @JsonProperty("Error")
        ERROR("Error"),
        @XmlEnumValue("Total")
        @JsonProperty("Total")
        TOTAL("Total");
        private final String value;

        Type(String v) {
            value = v;
        }

        @Override
        public String value() {
            return value;
        }

        public static AnovaRow.Type fromValue(String v) {
            for (AnovaRow.Type c: AnovaRow.Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

        @Override
        public String toString() {
            return value();
        }

    }

}
