
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.adapters.NumberAdapter;
import org.dmg.pmml.adapters.ObjectAdapter;
import org.dmg.pmml.adapters.ProbabilityNumberAdapter;
import org.jpmml.model.MissingAttributeException;
import org.jpmml.model.annotations.CollectionElementType;
import org.jpmml.model.annotations.CopyConstructor;
import org.jpmml.model.annotations.Optional;
import org.jpmml.model.annotations.ValueConstructor;

@XmlRootElement(name = "ScoreDistribution", namespace = "http://www.dmg.org/PMML-4_4")
@XmlType(name = "", propOrder = {
    "extensions"
})
@JsonRootName("ScoreDistribution")
@JsonPropertyOrder({
    "value",
    "recordCount",
    "confidence",
    "probability",
    "extensions"
})
public class ComplexScoreDistribution
    extends org.dmg.pmml.ScoreDistribution
    implements HasExtensions<ComplexScoreDistribution>
{

    @XmlAttribute(name = "value", required = true)
    @XmlJavaTypeAdapter(ObjectAdapter.class)
    @XmlSchemaType(name = "anySimpleType")
    @JsonProperty("value")
    private Object value;
    @XmlAttribute(name = "recordCount")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("recordCount")
    @Optional((org.dmg.pmml.Version.XPMML))
    private Number recordCount;
    @XmlAttribute(name = "confidence")
    @XmlJavaTypeAdapter(NumberAdapter.class)
    @JsonProperty("confidence")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_3_1))
    private Number confidence;
    @XmlAttribute(name = "probability")
    @XmlJavaTypeAdapter(ProbabilityNumberAdapter.class)
    @JsonProperty("probability")
    @org.jpmml.model.annotations.Added((org.dmg.pmml.Version.PMML_4_1))
    private Number probability;
    @XmlElement(name = "Extension", namespace = "http://www.dmg.org/PMML-4_4")
    @JsonProperty("Extension")
    @CollectionElementType(Extension.class)
    private List<Extension> extensions;
    private static final long serialVersionUID = 67371272L;

    public ComplexScoreDistribution() {
    }

    @CopyConstructor
    public ComplexScoreDistribution(org.dmg.pmml.ScoreDistribution scoreDistribution) {
        setValue(scoreDistribution.getValue());
        setRecordCount(scoreDistribution.getRecordCount());
        setConfidence(scoreDistribution.getConfidence());
        setProbability(scoreDistribution.getProbability());
        if (scoreDistribution.hasExtensions()) {
            getExtensions().addAll(scoreDistribution.getExtensions());
        }
    }

    @ValueConstructor
    public ComplexScoreDistribution(
        @org.jpmml.model.annotations.Property("value")
        Object value,
        @org.jpmml.model.annotations.Property("recordCount")
        Number recordCount) {
        this.value = value;
        this.recordCount = recordCount;
    }

    @Override
    public Object requireValue() {
        if (this.value == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXSCOREDISTRIBUTION_VALUE);
        }
        return this.value;
    }

    @Override
    public Object getValue() {
        return value;
    }

    @Override
    public ComplexScoreDistribution setValue(
        @org.jpmml.model.annotations.Property("value")
        Object value) {
        this.value = value;
        return this;
    }

    @Override
    public Number requireRecordCount() {
        if (this.recordCount == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXSCOREDISTRIBUTION_RECORDCOUNT);
        }
        return this.recordCount;
    }

    @Override
    public Number getRecordCount() {
        return recordCount;
    }

    @Override
    public ComplexScoreDistribution setRecordCount(
        @org.jpmml.model.annotations.Property("recordCount")
        Number recordCount) {
        this.recordCount = recordCount;
        return this;
    }

    @Override
    public Number getConfidence() {
        return confidence;
    }

    @Override
    public ComplexScoreDistribution setConfidence(
        @org.jpmml.model.annotations.Property("confidence")
        Number confidence) {
        this.confidence = confidence;
        return this;
    }

    @Override
    public Number requireProbability() {
        if (this.probability == null) {
            throw new MissingAttributeException(this, PMMLAttributes.COMPLEXSCOREDISTRIBUTION_PROBABILITY);
        }
        return this.probability;
    }

    @Override
    public Number getProbability() {
        return probability;
    }

    @Override
    public ComplexScoreDistribution setProbability(
        @org.jpmml.model.annotations.Property("probability")
        Number probability) {
        this.probability = probability;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return ((this.extensions!= null)&&(!this.extensions.isEmpty()));
    }

    @Override
    public List<Extension> getExtensions() {
        if (extensions == null) {
            extensions = new ArrayList<>();
        }
        return this.extensions;
    }

    @Override
    public ComplexScoreDistribution addExtensions(Extension... extensions) {
        getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public ComplexScoreDistribution toComplexScoreDistribution() {
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if ((status == VisitorAction.CONTINUE)&&hasExtensions()) {
                status = PMMLObject.traverse(visitor, getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

}
